/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.startup;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.StartupStep;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.support.startup.DefaultStartupStep;

public class DefaultStartupStepRecorder
extends ServiceSupport
implements StartupStepRecorder {
    private static final StartupStep DISABLED_STEP = new StartupStep(){

        public String getType() {
            return null;
        }

        public String getName() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public int getId() {
            return 0;
        }

        public int getParentId() {
            return 0;
        }

        public int getLevel() {
            return 0;
        }

        public long getBeginTime() {
            return 0L;
        }

        public long getDuration() {
            return 0L;
        }

        public void endStep() {
        }
    };
    private final AtomicInteger stepCounter = new AtomicInteger();
    private final Deque<Integer> currentSteps = new ArrayDeque<Integer>();
    private boolean enabled;
    private int maxDepth = -1;
    private long startupRecorderDuration;
    private boolean recording;
    private String recordingDir;
    private String recordingProfile = "default";

    public DefaultStartupStepRecorder() {
        this.currentSteps.offerFirst(0);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public long getStartupRecorderDuration() {
        return this.startupRecorderDuration;
    }

    public void setStartupRecorderDuration(long startupRecorderDuration) {
        this.startupRecorderDuration = startupRecorderDuration;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void setRecording(boolean recording) {
        this.recording = recording;
    }

    public String getRecordingDir() {
        return this.recordingDir;
    }

    public void setRecordingDir(String recordingDir) {
        this.recordingDir = recordingDir;
    }

    public String getRecordingProfile() {
        return this.recordingProfile;
    }

    public void setRecordingProfile(String recordingProfile) {
        this.recordingProfile = recordingProfile;
    }

    protected void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        this.enabled = false;
        this.currentSteps.clear();
    }

    public StartupStep beginStep(Class<?> type, String name, String description) {
        if (this.enabled) {
            int level = this.currentSteps.size() - 1;
            if (this.maxDepth != -1 && level >= this.maxDepth) {
                return DISABLED_STEP;
            }
            int id = this.stepCounter.incrementAndGet();
            Integer parent = this.currentSteps.peekFirst();
            int pid = parent != null ? parent : 0;
            StartupStep step = this.createStartupStep(type.getSimpleName(), name, description, id, pid, level);
            this.onBeginStep(step);
            this.currentSteps.offerFirst(id);
            return step;
        }
        return DISABLED_STEP;
    }

    public void endStep(StartupStep step) {
        if (step != DISABLED_STEP) {
            this.currentSteps.pollFirst();
            step.endStep();
            this.onEndStep(step);
        }
    }

    public StartupStep createStartupStep(String type, String name, String description, int id, int parentId, int level) {
        return new DefaultStartupStep(type, name, description, id, parentId, level, System.currentTimeMillis());
    }

    protected void onBeginStep(StartupStep step) {
    }

    protected void onEndStep(StartupStep step) {
    }
}

