/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.rest;

import org.apache.directory.fortress.core.AdminMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.PermGrant;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.PermissionAttribute;
import org.apache.directory.fortress.core.model.PermissionAttributeSet;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.RoleConstraint;
import org.apache.directory.fortress.core.model.RoleRelationship;
import org.apache.directory.fortress.core.model.SDSet;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.rest.RestUtils;
import org.apache.directory.fortress.core.util.VUtil;

public final class AdminMgrRestImpl
extends Manageable
implements AdminMgr {
    private static final String CLS_NM = AdminMgrRestImpl.class.getName();

    @Override
    public User addUser(User user) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".addUser");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        User retUser = (User)response.getEntity();
        return retUser;
    }

    @Override
    public void disableUser(User user) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".disableUser");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userDisable");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void deleteUser(User user) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".deleteUser");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userDelete");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public User updateUser(User user) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".updateUser");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userUpdate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        User retUser = (User)response.getEntity();
        return retUser;
    }

    @Override
    public void changePassword(User user, String newPassword) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".changePassword");
        VUtil.assertNotNullOrEmpty(newPassword, 1009, CLS_NM + ".changePassword");
        FortRequest request = RestUtils.getRequest(this.contextId);
        user.setNewPassword(newPassword);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userChange");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void lockUserAccount(User user) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".lockUserAccount");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userLock");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void unlockUserAccount(User user) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".unlockUserAccount");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userUnlock");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void resetPassword(User user, String newPassword) throws SecurityException {
        VUtil.assertNotNull(user, 1008, CLS_NM + ".resetPassword");
        VUtil.assertNotNullOrEmpty(newPassword, 1009, CLS_NM + ".resetPassword");
        FortRequest request = RestUtils.getRequest(this.contextId);
        user.setNewPassword(newPassword);
        request.setEntity(user);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userReset");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void deletePasswordPolicy(User user) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Role addRole(Role role) throws SecurityException {
        VUtil.assertNotNull(role, 5007, CLS_NM + ".addRole");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Role retRole = (Role)response.getEntity();
        return retRole;
    }

    @Override
    public void deleteRole(Role role) throws SecurityException {
        VUtil.assertNotNull(role, 5007, CLS_NM + ".deleteRole");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleDelete");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public Role updateRole(Role role) throws SecurityException {
        VUtil.assertNotNull(role, 5007, CLS_NM + ".updateRole");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleUpdate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Role retRole = (Role)response.getEntity();
        return retRole;
    }

    @Override
    public void assignUser(UserRole uRole) throws SecurityException {
        VUtil.assertNotNull(uRole, 2003, CLS_NM + ".assignUser");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(uRole);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleAsgn");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void deassignUser(UserRole uRole) throws SecurityException {
        VUtil.assertNotNull(uRole, 2003, CLS_NM + ".deassignUser");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(uRole);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleDeasgn");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public Permission addPermission(Permission perm) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".addPermission");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(perm);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "permAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Permission retPerm = (Permission)response.getEntity();
        return retPerm;
    }

    @Override
    public Permission updatePermission(Permission perm) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".updatePermission");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(perm);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "permUpdate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Permission retPerm = (Permission)response.getEntity();
        return retPerm;
    }

    @Override
    public void deletePermission(Permission perm) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".deletePermission");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(perm);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "permDelete");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public PermObj addPermObj(PermObj pObj) throws SecurityException {
        VUtil.assertNotNull(pObj, 3010, CLS_NM + ".addPermObj");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(pObj);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "objAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        PermObj retObj = (PermObj)response.getEntity();
        return retObj;
    }

    @Override
    public PermObj updatePermObj(PermObj pObj) throws SecurityException {
        VUtil.assertNotNull(pObj, 3010, CLS_NM + ".updatePermObj");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(pObj);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "objUpdate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        PermObj retObj = (PermObj)response.getEntity();
        return retObj;
    }

    @Override
    public void deletePermObj(PermObj pObj) throws SecurityException {
        VUtil.assertNotNull(pObj, 3010, CLS_NM + ".deletePermObj");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(pObj);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "objDelete");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void grantPermission(Permission perm, Role role) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".grantPermission");
        VUtil.assertNotNull(role, 5007, CLS_NM + ".grantPermission");
        FortRequest request = RestUtils.getRequest(this.contextId);
        PermGrant permGrant = new PermGrant();
        permGrant.setAdmin(perm.isAdmin());
        permGrant.setObjName(perm.getObjName());
        permGrant.setObjId(perm.getObjId());
        permGrant.setOpName(perm.getOpName());
        permGrant.setRoleNm(role.getName());
        request.setEntity(permGrant);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleGrant");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void revokePermission(Permission perm, Role role) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".revokePermission");
        VUtil.assertNotNull(role, 5007, CLS_NM + ".revokePermission");
        FortRequest request = RestUtils.getRequest(this.contextId);
        PermGrant permGrant = new PermGrant();
        permGrant.setAdmin(perm.isAdmin());
        permGrant.setObjName(perm.getObjName());
        permGrant.setObjId(perm.getObjId());
        permGrant.setOpName(perm.getOpName());
        permGrant.setRoleNm(role.getName());
        request.setEntity(permGrant);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleRevoke");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void grantPermission(Permission perm, User user) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".grantPermissionUser");
        VUtil.assertNotNull(user, 1008, CLS_NM + ".grantPermissionUser");
        FortRequest request = RestUtils.getRequest(this.contextId);
        PermGrant permGrant = new PermGrant();
        permGrant.setAdmin(perm.isAdmin());
        permGrant.setObjName(perm.getObjName());
        permGrant.setObjId(perm.getObjId());
        permGrant.setOpName(perm.getOpName());
        permGrant.setUserId(user.getUserId());
        request.setEntity(permGrant);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userGrant");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void revokePermission(Permission perm, User user) throws SecurityException {
        VUtil.assertNotNull(perm, 3009, CLS_NM + ".revokePermission");
        VUtil.assertNotNull(user, 1008, CLS_NM + ".revokePermission");
        FortRequest request = RestUtils.getRequest(this.contextId);
        PermGrant permGrant = new PermGrant();
        permGrant.setAdmin(perm.isAdmin());
        permGrant.setObjName(perm.getObjName());
        permGrant.setObjId(perm.getObjId());
        permGrant.setOpName(perm.getOpName());
        permGrant.setUserId(user.getUserId());
        request.setEntity(permGrant);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "userRevoke");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void addDescendant(Role parentRole, Role childRole) throws SecurityException {
        VUtil.assertNotNull(parentRole, 5013, CLS_NM + ".addDescendant");
        VUtil.assertNotNull(childRole, 5014, CLS_NM + ".addDescendant");
        FortRequest request = RestUtils.getRequest(this.contextId);
        RoleRelationship relationship = new RoleRelationship();
        relationship.setParent(parentRole);
        relationship.setChild(childRole);
        request.setEntity(relationship);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleDescendant");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void addAscendant(Role childRole, Role parentRole) throws SecurityException {
        VUtil.assertNotNull(parentRole, 5013, CLS_NM + ".addAscendant");
        VUtil.assertNotNull(childRole, 5014, CLS_NM + ".addAscendant");
        FortRequest request = RestUtils.getRequest(this.contextId);
        RoleRelationship relationship = new RoleRelationship();
        relationship.setParent(parentRole);
        relationship.setChild(childRole);
        request.setEntity(relationship);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleAscendent");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void addInheritance(Role parentRole, Role childRole) throws SecurityException {
        VUtil.assertNotNull(parentRole, 5013, CLS_NM + ".addInheritance");
        VUtil.assertNotNull(childRole, 5014, CLS_NM + ".addInheritance");
        FortRequest request = RestUtils.getRequest(this.contextId);
        RoleRelationship relationship = new RoleRelationship();
        relationship.setParent(parentRole);
        relationship.setChild(childRole);
        request.setEntity(relationship);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleAddinherit");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void deleteInheritance(Role parentRole, Role childRole) throws SecurityException {
        VUtil.assertNotNull(parentRole, 5013, CLS_NM + ".deleteInheritance");
        VUtil.assertNotNull(childRole, 5014, CLS_NM + ".deleteInheritance");
        FortRequest request = RestUtils.getRequest(this.contextId);
        RoleRelationship relationship = new RoleRelationship();
        relationship.setParent(parentRole);
        relationship.setChild(childRole);
        request.setEntity(relationship);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleDelinherit");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public SDSet createSsdSet(SDSet ssdSet) throws SecurityException {
        VUtil.assertNotNull(ssdSet, 5087, CLS_NM + ".createSsdSet");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(ssdSet);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "ssdAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet;
    }

    @Override
    public SDSet updateSsdSet(SDSet ssdSet) throws SecurityException {
        VUtil.assertNotNull(ssdSet, 5087, CLS_NM + ".updateSsdSet");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(ssdSet);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "ssdUpdate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet;
    }

    @Override
    public SDSet addSsdRoleMember(SDSet ssdSet, Role role) throws SecurityException {
        VUtil.assertNotNull(ssdSet, 5087, CLS_NM + ".addSsdRoleMember");
        VUtil.assertNotNull(role, 5007, CLS_NM + ".addSsdRoleMember");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(ssdSet);
        request.setValue(role.getName());
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "ssdAddMember");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet;
    }

    @Override
    public SDSet deleteSsdRoleMember(SDSet ssdSet, Role role) throws SecurityException {
        VUtil.assertNotNull(ssdSet, 5087, CLS_NM + ".deleteSsdRoleMember");
        VUtil.assertNotNull(role, 5007, CLS_NM + ".deleteSsdRoleMember");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(ssdSet);
        request.setValue(role.getName());
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "ssdDelMember");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet;
    }

    @Override
    public SDSet deleteSsdSet(SDSet ssdSet) throws SecurityException {
        VUtil.assertNotNull(ssdSet, 5087, CLS_NM + ".deleteSsdSet");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(ssdSet);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "ssdDelete");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet;
    }

    @Override
    public SDSet setSsdSetCardinality(SDSet ssdSet, int cardinality) throws SecurityException {
        VUtil.assertNotNull(ssdSet, 5087, CLS_NM + ".setSsdSetCardinality");
        FortRequest request = RestUtils.getRequest(this.contextId);
        ssdSet.setCardinality(cardinality);
        request.setEntity(ssdSet);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "ssdCardUpdate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet;
    }

    @Override
    public SDSet createDsdSet(SDSet dsdSet) throws SecurityException {
        VUtil.assertNotNull(dsdSet, 5087, CLS_NM + ".createDsdSet");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(dsdSet);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "dsdAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet;
    }

    @Override
    public SDSet updateDsdSet(SDSet dsdSet) throws SecurityException {
        VUtil.assertNotNull(dsdSet, 5087, CLS_NM + ".updateDsdSet");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(dsdSet);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "dsdUpdate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet;
    }

    @Override
    public SDSet addDsdRoleMember(SDSet dsdSet, Role role) throws SecurityException {
        VUtil.assertNotNull(dsdSet, 5087, CLS_NM + ".addDsdRoleMember");
        VUtil.assertNotNull(role, 5007, CLS_NM + ".addDsdRoleMember");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(dsdSet);
        request.setValue(role.getName());
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "dsdAddMember");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet;
    }

    @Override
    public SDSet deleteDsdRoleMember(SDSet dsdSet, Role role) throws SecurityException {
        VUtil.assertNotNull(dsdSet, 5087, CLS_NM + ".deleteDsdRoleMember");
        VUtil.assertNotNull(role, 5007, CLS_NM + ".deleteSsdRoleMember");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(dsdSet);
        request.setValue(role.getName());
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "dsdDelMember");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet;
    }

    @Override
    public SDSet deleteDsdSet(SDSet dsdSet) throws SecurityException {
        VUtil.assertNotNull(dsdSet, 5087, CLS_NM + ".deleteDsdSet");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(dsdSet);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "dsdDelete");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet;
    }

    @Override
    public SDSet setDsdSetCardinality(SDSet dsdSet, int cardinality) throws SecurityException {
        VUtil.assertNotNull(dsdSet, 5087, CLS_NM + ".setSsdSetCardinality");
        FortRequest request = RestUtils.getRequest(this.contextId);
        dsdSet.setCardinality(cardinality);
        request.setEntity(dsdSet);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "dsdCardUpdate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        SDSet retSet = (SDSet)response.getEntity();
        return retSet;
    }

    @Override
    public RoleConstraint addRoleConstraint(UserRole uRole, RoleConstraint roleConstraint) throws SecurityException {
        VUtil.assertNotNull(uRole, 2003, CLS_NM + ".addRoleConstraint");
        VUtil.assertNotNull(roleConstraint, 10401, CLS_NM + ".addRoleConstraint");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(uRole);
        request.setEntity2(roleConstraint);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "addRoleConstraint");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        RoleConstraint retCnst = (RoleConstraint)response.getEntity();
        return retCnst;
    }

    @Override
    public void removeRoleConstraint(UserRole uRole, RoleConstraint roleConstraint) throws SecurityException {
        VUtil.assertNotNull(uRole, 2003, CLS_NM + ".removeRoleConstraint");
        VUtil.assertNotNull(roleConstraint, 10401, CLS_NM + ".removeRoleConstraint");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(uRole);
        request.setEntity2(roleConstraint);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "removeRoleConstraint");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public PermissionAttributeSet addPermissionAttributeSet(PermissionAttributeSet permAttributeSet) throws SecurityException {
        VUtil.assertNotNull(permAttributeSet, 3030, CLS_NM + ".addPermissionAttributeSet");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(permAttributeSet);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "addPermissionAttributeSet");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        PermissionAttributeSet retSet = (PermissionAttributeSet)response.getEntity();
        return retSet;
    }

    @Override
    public void deletePermissionAttributeSet(PermissionAttributeSet permAttributeSet) throws SecurityException {
        VUtil.assertNotNull(permAttributeSet, 3030, CLS_NM + ".deletePermissionAttributeSet");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(permAttributeSet);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "deletePermissionAttributeSet");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public PermissionAttribute addPermissionAttributeToSet(PermissionAttribute permAttribute, String attributeSetName) throws SecurityException {
        VUtil.assertNotNull(permAttribute, 3030, CLS_NM + ".addPermissionAttributeToSet");
        VUtil.assertNotNull(attributeSetName, 3036, CLS_NM + ".addPermissionAttributeToSet");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(permAttribute);
        request.setValue(attributeSetName);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "addPermissionAttributeToSet");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        PermissionAttribute retAttr = (PermissionAttribute)response.getEntity();
        return retAttr;
    }

    @Override
    public void removePermissionAttributeFromSet(PermissionAttribute permAttribute, String attributeSetName) throws SecurityException {
        VUtil.assertNotNull(permAttribute, 3030, CLS_NM + ".removePermissionAttributeFromSet");
        VUtil.assertNotNull(attributeSetName, 3036, CLS_NM + ".removePermissionAttributeFromSet");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(permAttribute);
        request.setValue(attributeSetName);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "removePermissionAttributeFromSet");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void updatePermissionAttributeInSet(PermissionAttribute permAttribute, String attributeSetName, boolean replaceValidValues) throws SecurityException {
        VUtil.assertNotNull(permAttribute, 3030, CLS_NM + ".updatePermissionAttributeInSet");
        VUtil.assertNotNull(attributeSetName, 3036, CLS_NM + ".updatePermissionAttributeInSet");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(permAttribute);
        request.setValue(attributeSetName);
        request.setIsFlag(replaceValidValues);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "updatePermissionAttributeInSet");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void removeRoleConstraint(UserRole uRole, String roleConstraintId) throws SecurityException {
        VUtil.assertNotNull(uRole, 2003, CLS_NM + ".removeRoleConstraint");
        VUtil.assertNotNull(roleConstraintId, 5101, CLS_NM + ".removeRoleConstraint");
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(uRole);
        request.setValue(roleConstraintId);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "removeRoleConstraintId");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void enableRoleConstraint(Role role, RoleConstraint roleConstraint) throws SecurityException {
        String methodName = ".enableRoleConstraint";
        VUtil.assertNotNull(role, 5007, CLS_NM + methodName);
        VUtil.assertNotNull(roleConstraint, 10401, CLS_NM + methodName);
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(role);
        request.setEntity2(roleConstraint);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleEnableConstraint");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void disableRoleConstraint(Role role, RoleConstraint roleConstraint) throws SecurityException {
        String methodName = ".disableRoleConstraint";
        VUtil.assertNotNull(role, 5007, CLS_NM + methodName);
        VUtil.assertNotNull(roleConstraint, 10401, CLS_NM + methodName);
        FortRequest request = RestUtils.getRequest(this.contextId);
        request.setEntity(role);
        request.setEntity2(roleConstraint);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "roleDisableConstraint");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }
}

