/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResults;
import org.apache.commons.validator.util.ValidatorUtils;

public class ValidatorAction
implements Serializable {
    private static final long serialVersionUID = 1339713700053204597L;
    private transient Log log = LogFactory.getLog(ValidatorAction.class);
    private String name;
    private String className;
    private Class<?> validationClass;
    private String method;
    private transient Method validationMethod;
    private String methodParams = "java.lang.Object,org.apache.commons.validator.ValidatorAction,org.apache.commons.validator.Field";
    private Class<?>[] parameterClasses;
    private String depends;
    private String msg;
    private String jsFunctionName;
    private String jsFunction;
    private String javascript;
    private Object instance;
    private final List<String> dependencyList = Collections.synchronizedList(new ArrayList());
    private final List<String> methodParameterList = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeValidationMethod(Field field, Map<String, Object> params, ValidatorResults results, int pos) throws ValidatorException {
        params.put("org.apache.commons.validator.ValidatorAction", this);
        try {
            Object result;
            block14: {
                if (this.validationMethod == null) {
                    ValidatorAction validatorAction = this;
                    synchronized (validatorAction) {
                        ClassLoader loader = this.getClassLoader(params);
                        this.loadValidationClass(loader);
                        this.loadParameterClasses(loader);
                        this.loadValidationMethod();
                    }
                }
                Object[] paramValues = this.getParameterValues(params);
                if (field.isIndexed()) {
                    this.handleIndexedField(field, pos, paramValues);
                }
                result = null;
                try {
                    result = this.validationMethod.invoke(this.getValidationClassInstance(), paramValues);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new ValidatorException(e.getMessage());
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof Exception) {
                        throw (Exception)e.getTargetException();
                    }
                    if (!(e.getTargetException() instanceof Error)) break block14;
                    throw (Error)e.getTargetException();
                }
            }
            boolean valid = this.isValid(result);
            if (!valid || valid && !this.onlyReturnErrors(params)) {
                results.add(field, this.name, valid, result);
            }
            if (!valid) {
                return false;
            }
        }
        catch (Exception e) {
            if (e instanceof ValidatorException) {
                throw (ValidatorException)e;
            }
            this.getLog().error("Unhandled exception thrown during validation: " + e.getMessage(), e);
            results.add(field, this.name, false);
            return false;
        }
        return true;
    }

    private String formatJavaScriptFileName() {
        String fname = this.jsFunction.substring(1);
        if (!this.jsFunction.startsWith("/")) {
            fname = this.jsFunction.replace('.', '/') + ".js";
        }
        return fname;
    }

    private String generateJsFunction() {
        StringBuilder jsName = new StringBuilder("org.apache.commons.validator.javascript");
        jsName.append(".validate");
        jsName.append(this.name.substring(0, 1).toUpperCase());
        jsName.append(this.name.substring(1));
        return jsName.toString();
    }

    private ClassLoader getClassLoader(Map<String, Object> params) {
        Validator v = this.getValidator(params);
        return v.getClassLoader();
    }

    public String getClassname() {
        return this.className;
    }

    public List<String> getDependencyList() {
        return Collections.unmodifiableList(this.dependencyList);
    }

    public String getDepends() {
        return this.depends;
    }

    public synchronized String getJavascript() {
        return this.javascript;
    }

    public String getJsFunctionName() {
        return this.jsFunctionName;
    }

    private Log getLog() {
        if (this.log == null) {
            this.log = LogFactory.getLog(ValidatorAction.class);
        }
        return this.log;
    }

    public String getMethod() {
        return this.method;
    }

    public String getMethodParams() {
        return this.methodParams;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getName() {
        return this.name;
    }

    private Object[] getParameterValues(Map<String, ? super Object> params) {
        Object[] paramValue = new Object[this.methodParameterList.size()];
        for (int i2 = 0; i2 < this.methodParameterList.size(); ++i2) {
            String paramClassName = this.methodParameterList.get(i2);
            paramValue[i2] = params.get(paramClassName);
        }
        return paramValue;
    }

    private Object getValidationClassInstance() throws ValidatorException {
        if (Modifier.isStatic(this.validationMethod.getModifiers())) {
            this.instance = null;
        } else if (this.instance == null) {
            try {
                this.instance = this.validationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                String msg1 = "Couldn't create instance of " + this.className + ".  " + e.getMessage();
                throw new ValidatorException(msg1);
            }
        }
        return this.instance;
    }

    private Validator getValidator(Map<String, Object> params) {
        return (Validator)params.get("org.apache.commons.validator.Validator");
    }

    private void handleIndexedField(Field field, int pos, Object[] paramValues) throws ValidatorException {
        int beanIndex = this.methodParameterList.indexOf("java.lang.Object");
        int fieldIndex = this.methodParameterList.indexOf("org.apache.commons.validator.Field");
        Object[] indexedList = field.getIndexedProperty(paramValues[beanIndex]);
        paramValues[beanIndex] = indexedList[pos];
        Field indexedField = (Field)field.clone();
        indexedField.setKey(ValidatorUtils.replace(indexedField.getKey(), "[]", "[" + pos + "]"));
        paramValues[fieldIndex] = indexedField;
    }

    protected void init() {
        this.loadJavascriptFunction();
    }

    public boolean isDependency(String validatorName) {
        return this.dependencyList.contains(validatorName);
    }

    private boolean isValid(Object result) {
        if (result instanceof Boolean) {
            Boolean valid = (Boolean)result;
            return valid;
        }
        return result != null;
    }

    private boolean javaScriptAlreadyLoaded() {
        return this.javascript != null;
    }

    protected synchronized void loadJavascriptFunction() {
        if (this.javaScriptAlreadyLoaded()) {
            return;
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace("  Loading function begun");
        }
        if (this.jsFunction == null) {
            this.jsFunction = this.generateJsFunction();
        }
        String javaScriptFileName = this.formatJavaScriptFileName();
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace("  Loading js function '" + javaScriptFileName + "'");
        }
        this.javascript = this.readJavaScriptFile(javaScriptFileName);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace("  Loading JavaScript function completed");
        }
    }

    private void loadParameterClasses(ClassLoader loader) throws ValidatorException {
        if (this.parameterClasses != null) {
            return;
        }
        Class[] parameterClasses = new Class[this.methodParameterList.size()];
        for (int i2 = 0; i2 < this.methodParameterList.size(); ++i2) {
            String paramClassName = this.methodParameterList.get(i2);
            try {
                parameterClasses[i2] = loader.loadClass(paramClassName);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new ValidatorException(e.getMessage());
            }
        }
        this.parameterClasses = parameterClasses;
    }

    private void loadValidationClass(ClassLoader loader) throws ValidatorException {
        if (this.validationClass != null) {
            return;
        }
        try {
            this.validationClass = loader.loadClass(this.className);
        }
        catch (ClassNotFoundException e) {
            throw new ValidatorException(e.toString());
        }
    }

    private void loadValidationMethod() throws ValidatorException {
        if (this.validationMethod != null) {
            return;
        }
        try {
            this.validationMethod = this.validationClass.getMethod(this.method, this.parameterClasses);
        }
        catch (NoSuchMethodException e) {
            throw new ValidatorException("No such validation method: " + e.getMessage());
        }
    }

    private boolean onlyReturnErrors(Map<String, Object> params) {
        Validator v = this.getValidator(params);
        return v.getOnlyReturnErrors();
    }

    private InputStream openInputStream(String javaScriptFileName, ClassLoader classLoader) {
        InputStream is = null;
        if (classLoader != null) {
            is = classLoader.getResourceAsStream(javaScriptFileName);
        }
        if (is == null) {
            return this.getClass().getResourceAsStream(javaScriptFileName);
        }
        return is;
    }

    private String readJavaScriptFile(String javaScriptFileName) {
        InputStream is;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((is = this.openInputStream(javaScriptFileName, classLoader)) == null) {
            this.getLog().debug("  Unable to read javascript name " + javaScriptFileName);
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line).append("\n");
            }
        }
        catch (IOException e) {
            this.getLog().error("Error reading JavaScript file.", e);
        }
        String function = buffer.toString();
        return function.isEmpty() ? null : function;
    }

    @Deprecated
    public void setClassname(String className) {
        this.className = className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setDepends(String depends) {
        this.depends = depends;
        this.dependencyList.clear();
        StringTokenizer st = new StringTokenizer(depends, ",");
        while (st.hasMoreTokens()) {
            String depend = st.nextToken().trim();
            if (depend == null || depend.isEmpty()) continue;
            this.dependencyList.add(depend);
        }
    }

    public synchronized void setJavascript(String javaScript) {
        if (this.jsFunction != null) {
            throw new IllegalStateException("Cannot call setJavascript() after calling setJsFunction()");
        }
        this.javascript = javaScript;
    }

    public synchronized void setJsFunction(String jsFunction) {
        if (this.javascript != null) {
            throw new IllegalStateException("Cannot call setJsFunction() after calling setJavascript()");
        }
        this.jsFunction = jsFunction;
    }

    public void setJsFunctionName(String jsFunctionName) {
        this.jsFunctionName = jsFunctionName;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setMethodParams(String methodParams) {
        this.methodParams = methodParams;
        this.methodParameterList.clear();
        StringTokenizer st = new StringTokenizer(methodParams, ",");
        while (st.hasMoreTokens()) {
            String value = st.nextToken().trim();
            if (value == null || value.isEmpty()) continue;
            this.methodParameterList.add(value);
        }
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder results = new StringBuilder("ValidatorAction: ");
        results.append(this.name);
        results.append("\n");
        return results.toString();
    }
}

