/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.cli.command;

import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.util.functional.ThrowingSupplier;
import jakarta.inject.Inject;
import java.io.IOException;
import org.grails.forge.application.Project;
import org.grails.forge.cli.CodeGenConfig;
import org.grails.forge.cli.command.CodeGenCommand;
import org.grails.forge.cli.command.templates.service;
import org.grails.forge.cli.command.templates.serviceSpec;
import org.grails.forge.io.ConsoleOutput;
import org.grails.forge.io.OutputHandler;
import org.grails.forge.template.RenderResult;
import org.grails.forge.template.RockerTemplate;
import org.grails.forge.template.TemplateRenderer;
import picocli.CommandLine;

@CommandLine.Command(name="create-service", description={"Creates a Service Class"})
public class CreateServiceCommand
extends CodeGenCommand {
    public static final String NAME = "create-service";
    @ReflectiveAccess
    @CommandLine.Parameters(paramLabel="SERVICE-NAME", description={"The name of the service to create"})
    String serviceName;

    @Inject
    public CreateServiceCommand(@Parameter CodeGenConfig config) {
        super(config);
    }

    public CreateServiceCommand(CodeGenConfig config, ThrowingSupplier<OutputHandler, IOException> outputHandlerSupplier, ConsoleOutput consoleOutput) {
        super(config, outputHandlerSupplier, consoleOutput);
    }

    @Override
    public boolean applies() {
        return true;
    }

    @Override
    public Integer call() throws Exception {
        Project project = this.getProject(this.serviceName);
        TemplateRenderer templateRenderer = this.getTemplateRenderer(project);
        RenderResult renderResult = templateRenderer.render(new RockerTemplate("grails-app/services/{packagePath}/{className}Service.groovy", service.template(project)), this.overwrite);
        RenderResult specRenderResult = templateRenderer.render(new RockerTemplate("src/test/groovy/{packagePath}/{className}ServiceSpec.groovy", serviceSpec.template(project)), this.overwrite);
        if (renderResult != null && specRenderResult != null) {
            this.logRenderResult(renderResult);
            this.logRenderResult(specRenderResult);
        }
        return 0;
    }

    private void logRenderResult(RenderResult result) throws Exception {
        if (result != null) {
            if (result.isSuccess()) {
                this.out("@|blue ||@ Rendered service class to " + result.getPath());
            } else if (result.isSkipped()) {
                this.warning("Rendering skipped for " + result.getPath() + " because it already exists. Run again with -f to overwrite.");
            } else if (result.getError() != null) {
                throw result.getError();
            }
        }
    }
}

