/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.template;

public interface RenderResult {
    public boolean isSuccess();

    public boolean isSkipped();

    public String getPath();

    public Exception getError();

    public static RenderResult skipped(final String path) {
        return new RenderResult(){

            @Override
            public boolean isSuccess() {
                return false;
            }

            @Override
            public boolean isSkipped() {
                return true;
            }

            @Override
            public String getPath() {
                return path;
            }

            @Override
            public Exception getError() {
                return null;
            }
        };
    }

    public static RenderResult success(final String path) {
        return new RenderResult(){

            @Override
            public boolean isSuccess() {
                return true;
            }

            @Override
            public boolean isSkipped() {
                return false;
            }

            @Override
            public String getPath() {
                return path;
            }

            @Override
            public Exception getError() {
                return null;
            }
        };
    }

    public static RenderResult error(final String path, final Exception t) {
        return new RenderResult(){

            @Override
            public boolean isSuccess() {
                return false;
            }

            @Override
            public boolean isSkipped() {
                return false;
            }

            @Override
            public String getPath() {
                return path;
            }

            @Override
            public Exception getError() {
                return t;
            }
        };
    }
}

