/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.MethodDescriptor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class DisposableBeanAdapter
implements DisposableBean,
Runnable,
Serializable {
    private static final String DESTROY_METHOD_NAME = "destroy";
    private static final String CLOSE_METHOD_NAME = "close";
    private static final String SHUTDOWN_METHOD_NAME = "shutdown";
    private static final Log logger = LogFactory.getLog(DisposableBeanAdapter.class);
    private static final boolean reactiveStreamsPresent = ClassUtils.isPresent("org.reactivestreams.Publisher", DisposableBeanAdapter.class.getClassLoader());
    private final Object bean;
    private final String beanName;
    private final boolean nonPublicAccessAllowed;
    private final boolean invokeDisposableBean;
    private boolean invokeAutoCloseable;
    @Nullable
    private String[] destroyMethodNames;
    @Nullable
    private transient Method[] destroyMethods;
    @Nullable
    private final List<DestructionAwareBeanPostProcessor> beanPostProcessors;

    public DisposableBeanAdapter(Object bean2, String beanName, RootBeanDefinition beanDefinition, List<DestructionAwareBeanPostProcessor> postProcessors) {
        Assert.notNull(bean2, "Disposable bean must not be null");
        this.bean = bean2;
        this.beanName = beanName;
        this.nonPublicAccessAllowed = beanDefinition.isNonPublicAccessAllowed();
        this.invokeDisposableBean = bean2 instanceof DisposableBean && !beanDefinition.hasAnyExternallyManagedDestroyMethod(DESTROY_METHOD_NAME);
        Object[] destroyMethodNames = DisposableBeanAdapter.inferDestroyMethodsIfNecessary(bean2.getClass(), beanDefinition);
        if (!(ObjectUtils.isEmpty(destroyMethodNames) || this.invokeDisposableBean && DESTROY_METHOD_NAME.equals(destroyMethodNames[0]) || beanDefinition.hasAnyExternallyManagedDestroyMethod((String)destroyMethodNames[0]))) {
            boolean bl = this.invokeAutoCloseable = bean2 instanceof AutoCloseable && CLOSE_METHOD_NAME.equals(destroyMethodNames[0]);
            if (!this.invokeAutoCloseable) {
                this.destroyMethodNames = destroyMethodNames;
                ArrayList<Method> destroyMethods = new ArrayList<Method>(destroyMethodNames.length);
                for (Object destroyMethodName : destroyMethodNames) {
                    Method destroyMethod = this.determineDestroyMethod((String)destroyMethodName);
                    if (destroyMethod == null) {
                        if (!beanDefinition.isEnforceDestroyMethod()) continue;
                        throw new BeanDefinitionValidationException("Could not find a destroy method named '" + (String)destroyMethodName + "' on bean with name '" + beanName + "'");
                    }
                    if (destroyMethod.getParameterCount() > 0) {
                        Class<?>[] paramTypes = destroyMethod.getParameterTypes();
                        if (paramTypes.length > 1) {
                            throw new BeanDefinitionValidationException("Method '" + (String)destroyMethodName + "' of bean '" + beanName + "' has more than one parameter - not supported as destroy method");
                        }
                        if (paramTypes.length == 1 && Boolean.TYPE != paramTypes[0]) {
                            throw new BeanDefinitionValidationException("Method '" + (String)destroyMethodName + "' of bean '" + beanName + "' has a non-boolean parameter - not supported as destroy method");
                        }
                    }
                    destroyMethod = ClassUtils.getPubliclyAccessibleMethodIfPossible(destroyMethod, bean2.getClass());
                    destroyMethods.add(destroyMethod);
                }
                this.destroyMethods = (Method[])destroyMethods.toArray(Method[]::new);
            }
        }
        this.beanPostProcessors = DisposableBeanAdapter.filterPostProcessors(postProcessors, bean2);
    }

    public DisposableBeanAdapter(Object bean2, List<DestructionAwareBeanPostProcessor> postProcessors) {
        Assert.notNull(bean2, "Disposable bean must not be null");
        this.bean = bean2;
        this.beanName = bean2.getClass().getName();
        this.nonPublicAccessAllowed = true;
        this.invokeDisposableBean = this.bean instanceof DisposableBean;
        this.beanPostProcessors = DisposableBeanAdapter.filterPostProcessors(postProcessors, bean2);
    }

    private DisposableBeanAdapter(Object bean2, String beanName, boolean nonPublicAccessAllowed, boolean invokeDisposableBean, boolean invokeAutoCloseable, @Nullable String[] destroyMethodNames, @Nullable List<DestructionAwareBeanPostProcessor> postProcessors) {
        this.bean = bean2;
        this.beanName = beanName;
        this.nonPublicAccessAllowed = nonPublicAccessAllowed;
        this.invokeDisposableBean = invokeDisposableBean;
        this.invokeAutoCloseable = invokeAutoCloseable;
        this.destroyMethodNames = destroyMethodNames;
        this.beanPostProcessors = postProcessors;
    }

    @Override
    public void run() {
        this.destroy();
    }

    @Override
    public void destroy() {
        block14: {
            block16: {
                block15: {
                    String msg;
                    block13: {
                        if (!CollectionUtils.isEmpty(this.beanPostProcessors)) {
                            for (DestructionAwareBeanPostProcessor processor : this.beanPostProcessors) {
                                processor.postProcessBeforeDestruction(this.bean, this.beanName);
                            }
                        }
                        if (this.invokeDisposableBean) {
                            if (logger.isTraceEnabled()) {
                                logger.trace("Invoking destroy() on bean with name '" + this.beanName + "'");
                            }
                            try {
                                ((DisposableBean)this.bean).destroy();
                            }
                            catch (Throwable ex) {
                                if (!logger.isWarnEnabled()) break block13;
                                msg = "Invocation of destroy method failed on bean with name '" + this.beanName + "'";
                                if (logger.isDebugEnabled()) {
                                    logger.warn(msg, ex);
                                }
                                logger.warn(msg + ": " + String.valueOf(ex));
                            }
                        }
                    }
                    if (!this.invokeAutoCloseable) break block15;
                    if (logger.isTraceEnabled()) {
                        logger.trace("Invoking close() on bean with name '" + this.beanName + "'");
                    }
                    try {
                        ((AutoCloseable)this.bean).close();
                    }
                    catch (Throwable ex) {
                        if (!logger.isWarnEnabled()) break block14;
                        msg = "Invocation of close method failed on bean with name '" + this.beanName + "'";
                        if (logger.isDebugEnabled()) {
                            logger.warn(msg, ex);
                            break block14;
                        }
                        logger.warn(msg + ": " + String.valueOf(ex));
                    }
                    break block14;
                }
                if (this.destroyMethods == null) break block16;
                for (Method destroyMethod : this.destroyMethods) {
                    this.invokeCustomDestroyMethod(destroyMethod);
                }
                break block14;
            }
            if (this.destroyMethodNames == null) break block14;
            for (String destroyMethodName : this.destroyMethodNames) {
                Method destroyMethod = this.determineDestroyMethod(destroyMethodName);
                if (destroyMethod == null) continue;
                destroyMethod = ClassUtils.getPubliclyAccessibleMethodIfPossible(destroyMethod, this.bean.getClass());
                this.invokeCustomDestroyMethod(destroyMethod);
            }
        }
    }

    @Nullable
    private Method determineDestroyMethod(String destroyMethodName) {
        try {
            Class<?> beanClass = this.bean.getClass();
            MethodDescriptor descriptor = MethodDescriptor.create(this.beanName, beanClass, destroyMethodName);
            String methodName = descriptor.methodName();
            Method destroyMethod = this.findDestroyMethod(descriptor.declaringClass(), methodName);
            if (destroyMethod != null) {
                return destroyMethod;
            }
            for (Class<?> beanInterface : ClassUtils.getAllInterfacesForClass(beanClass)) {
                destroyMethod = this.findDestroyMethod(beanInterface, methodName);
                if (destroyMethod == null) continue;
                return destroyMethod;
            }
            return null;
        }
        catch (IllegalArgumentException ex) {
            throw new BeanDefinitionValidationException("Could not find unique destroy method on bean with name '" + this.beanName + ": " + ex.getMessage());
        }
    }

    @Nullable
    private Method findDestroyMethod(Class<?> clazz, String name) {
        return this.nonPublicAccessAllowed ? BeanUtils.findMethodWithMinimalParameters(clazz, name) : BeanUtils.findMethodWithMinimalParameters(clazz.getMethods(), name);
    }

    private void invokeCustomDestroyMethod(Method destroyMethod) {
        block10: {
            if (logger.isTraceEnabled()) {
                logger.trace("Invoking custom destroy method '" + destroyMethod.getName() + "' on bean with name '" + this.beanName + "': " + String.valueOf(destroyMethod));
            }
            int paramCount = destroyMethod.getParameterCount();
            Object[] args = new Object[paramCount];
            if (paramCount == 1) {
                args[0] = Boolean.TRUE;
            }
            try {
                ReflectionUtils.makeAccessible(destroyMethod);
                Object returnValue = destroyMethod.invoke(this.bean, args);
                if (returnValue == null) {
                    this.logDestroyMethodCompletion(destroyMethod, false);
                } else if (returnValue instanceof Future) {
                    Future future = (Future)returnValue;
                    future.get();
                    this.logDestroyMethodCompletion(destroyMethod, true);
                } else if (!(reactiveStreamsPresent && new ReactiveDestroyMethodHandler().await(destroyMethod, returnValue) || !logger.isDebugEnabled())) {
                    logger.debug("Unknown return value type from custom destroy method '" + destroyMethod.getName() + "' on bean with name '" + this.beanName + "': " + String.valueOf(returnValue.getClass()));
                }
            }
            catch (InvocationTargetException | ExecutionException ex) {
                this.logDestroyMethodException(destroyMethod, ex.getCause());
            }
            catch (Throwable ex) {
                if (!logger.isWarnEnabled()) break block10;
                logger.warn("Failed to invoke custom destroy method '" + destroyMethod.getName() + "' on bean with name '" + this.beanName + "'", ex);
            }
        }
    }

    void logDestroyMethodException(Method destroyMethod, @Nullable Throwable ex) {
        if (logger.isWarnEnabled()) {
            String msg = "Custom destroy method '" + destroyMethod.getName() + "' on bean with name '" + this.beanName + "' propagated an exception";
            if (logger.isDebugEnabled()) {
                logger.warn(msg, ex);
            } else {
                logger.warn(msg + ": " + String.valueOf(ex));
            }
        }
    }

    void logDestroyMethodCompletion(Method destroyMethod, boolean async) {
        if (logger.isDebugEnabled()) {
            logger.debug("Custom destroy method '" + destroyMethod.getName() + "' on bean with name '" + this.beanName + "' completed" + (async ? " asynchronously" : ""));
        }
    }

    protected Object writeReplace() {
        ArrayList<DestructionAwareBeanPostProcessor> serializablePostProcessors = null;
        if (this.beanPostProcessors != null) {
            serializablePostProcessors = new ArrayList<DestructionAwareBeanPostProcessor>();
            for (DestructionAwareBeanPostProcessor postProcessor : this.beanPostProcessors) {
                if (!(postProcessor instanceof Serializable)) continue;
                serializablePostProcessors.add(postProcessor);
            }
        }
        return new DisposableBeanAdapter(this.bean, this.beanName, this.nonPublicAccessAllowed, this.invokeDisposableBean, this.invokeAutoCloseable, this.destroyMethodNames, serializablePostProcessors);
    }

    public static boolean hasDestroyMethod(Object bean2, RootBeanDefinition beanDefinition) {
        return bean2 instanceof DisposableBean || DisposableBeanAdapter.inferDestroyMethodsIfNecessary(bean2.getClass(), beanDefinition) != null;
    }

    @Nullable
    static String[] inferDestroyMethodsIfNecessary(Class<?> target, RootBeanDefinition beanDefinition) {
        String[] stringArray;
        String[] destroyMethodNames = beanDefinition.getDestroyMethodNames();
        if (destroyMethodNames != null && destroyMethodNames.length > 1) {
            return destroyMethodNames;
        }
        String destroyMethodName = beanDefinition.resolvedDestroyMethodName;
        if (destroyMethodName == null) {
            destroyMethodName = beanDefinition.getDestroyMethodName();
            boolean autoCloseable = AutoCloseable.class.isAssignableFrom(target);
            boolean executorService = ExecutorService.class.isAssignableFrom(target);
            if ("(inferred)".equals(destroyMethodName) || destroyMethodName == null && (autoCloseable || executorService)) {
                destroyMethodName = null;
                if (!DisposableBean.class.isAssignableFrom(target)) {
                    if (executorService) {
                        destroyMethodName = SHUTDOWN_METHOD_NAME;
                        try {
                            if (target.getMethod(CLOSE_METHOD_NAME, new Class[0]).getDeclaringClass() != ExecutorService.class) {
                                destroyMethodName = CLOSE_METHOD_NAME;
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {}
                    } else if (autoCloseable) {
                        destroyMethodName = CLOSE_METHOD_NAME;
                    } else {
                        try {
                            destroyMethodName = target.getMethod(CLOSE_METHOD_NAME, new Class[0]).getName();
                        }
                        catch (NoSuchMethodException ex) {
                            try {
                                destroyMethodName = target.getMethod(SHUTDOWN_METHOD_NAME, new Class[0]).getName();
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            String string = beanDefinition.resolvedDestroyMethodName = destroyMethodName != null ? destroyMethodName : "";
        }
        if (StringUtils.hasLength(destroyMethodName)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = destroyMethodName;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public static boolean hasApplicableProcessors(Object bean2, List<DestructionAwareBeanPostProcessor> postProcessors) {
        if (!CollectionUtils.isEmpty(postProcessors)) {
            for (DestructionAwareBeanPostProcessor processor : postProcessors) {
                if (!processor.requiresDestruction(bean2)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static List<DestructionAwareBeanPostProcessor> filterPostProcessors(List<DestructionAwareBeanPostProcessor> processors, Object bean2) {
        ArrayList<DestructionAwareBeanPostProcessor> filteredPostProcessors = null;
        if (!CollectionUtils.isEmpty(processors)) {
            filteredPostProcessors = new ArrayList<DestructionAwareBeanPostProcessor>(processors.size());
            for (DestructionAwareBeanPostProcessor processor : processors) {
                if (!processor.requiresDestruction(bean2)) continue;
                filteredPostProcessors.add(processor);
            }
        }
        return filteredPostProcessors;
    }

    private class ReactiveDestroyMethodHandler {
        private ReactiveDestroyMethodHandler() {
        }

        public boolean await(Method destroyMethod, Object returnValue) throws InterruptedException {
            ReactiveAdapter adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(returnValue.getClass());
            if (adapter != null) {
                CountDownLatch latch = new CountDownLatch(1);
                adapter.toPublisher(returnValue).subscribe(new DestroyMethodSubscriber(destroyMethod, latch));
                latch.await();
                return true;
            }
            return false;
        }
    }

    private class DestroyMethodSubscriber
    implements Subscriber<Object> {
        private final Method destroyMethod;
        private final CountDownLatch latch;

        public DestroyMethodSubscriber(Method destroyMethod, CountDownLatch latch) {
            this.destroyMethod = destroyMethod;
            this.latch = latch;
        }

        @Override
        public void onSubscribe(Subscription s) {
            s.request(Integer.MAX_VALUE);
        }

        @Override
        public void onNext(Object o) {
        }

        @Override
        public void onError(Throwable t) {
            this.latch.countDown();
            DisposableBeanAdapter.this.logDestroyMethodException(this.destroyMethod, t);
        }

        @Override
        public void onComplete() {
            this.latch.countDown();
            DisposableBeanAdapter.this.logDestroyMethodCompletion(this.destroyMethod, true);
        }
    }
}

