/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.HexFormat;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.springframework.boot.loader.tools.EntryWriter;
import org.springframework.boot.loader.tools.Layer;
import org.springframework.boot.loader.tools.Layers;
import org.springframework.boot.loader.tools.LayersIndex;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LoaderClassesWriter;
import org.springframework.boot.loader.tools.LoaderImplementation;
import org.springframework.boot.loader.tools.SizeCalculatingEntryWriter;
import org.springframework.boot.loader.tools.ZipHeaderPeekInputStream;

public abstract class AbstractJarWriter
implements LoaderClassesWriter {
    private static final int BUFFER_SIZE = 32768;
    private static final int UNIX_FILE_MODE = 33188;
    private static final int UNIX_DIR_MODE = 16877;
    private final Set<String> writtenEntries = new HashSet<String>();
    private Layers layers;
    private LayersIndex layersIndex;

    void useLayers(Layers layers, LayersIndex layersIndex) {
        this.layers = layers;
        this.layersIndex = layersIndex;
    }

    public void writeManifest(Manifest manifest) throws IOException {
        JarArchiveEntry entry = new JarArchiveEntry("META-INF/MANIFEST.MF");
        this.writeEntry(entry, manifest::write);
    }

    final void writeEntries(JarFile jarFile, EntryTransformer entryTransformer, UnpackHandler unpackHandler, Function<JarEntry, Library> libraryLookup) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Library library = libraryLookup.apply(entry);
            if (library != null && !library.isIncluded()) continue;
            this.writeEntry(jarFile, entryTransformer, unpackHandler, new JarArchiveEntry(entry), library);
        }
    }

    private void writeEntry(JarFile jarFile, EntryTransformer entryTransformer, UnpackHandler unpackHandler, JarArchiveEntry entry, Library library) throws IOException {
        this.setUpEntry(jarFile, entry, unpackHandler);
        try (ZipHeaderPeekInputStream inputStream = new ZipHeaderPeekInputStream(jarFile.getInputStream(entry));){
            InputStreamEntryWriter entryWriter = new InputStreamEntryWriter(inputStream);
            JarArchiveEntry transformedEntry = entryTransformer.transform(entry);
            if (transformedEntry != null) {
                this.writeEntry(transformedEntry, library, entryWriter);
            }
        }
    }

    private void setUpEntry(JarFile jarFile, JarArchiveEntry entry, UnpackHandler unpackHandler) throws IOException {
        try (ZipHeaderPeekInputStream inputStream = new ZipHeaderPeekInputStream(jarFile.getInputStream(entry));){
            if (inputStream.hasZipHeader() && entry.getMethod() != 0) {
                new StoredEntryPreparator(inputStream, unpackHandler.requiresUnpack(entry.getName())).prepareStoredEntry(entry);
            } else {
                entry.setCompressedSize(-1L);
            }
        }
    }

    @Override
    public void writeEntry(String entryName, InputStream inputStream) throws IOException {
        try (InputStream inputStream2 = inputStream;){
            this.writeEntry(entryName, (EntryWriter)new InputStreamEntryWriter(inputStream));
        }
    }

    public void writeEntry(String entryName, EntryWriter entryWriter) throws IOException {
        JarArchiveEntry entry = new JarArchiveEntry(entryName);
        this.writeEntry(entry, entryWriter);
    }

    public void writeNestedLibrary(String location, Library library) throws IOException {
        JarArchiveEntry entry = new JarArchiveEntry(location + library.getName());
        entry.setTime(this.getNestedLibraryTime(library));
        new StoredEntryPreparator(library.openStream(), new LibraryUnpackHandler(library).requiresUnpack(location)).prepareStoredEntry(entry);
        try (InputStream inputStream = library.openStream();){
            this.writeEntry(entry, library, new InputStreamEntryWriter(inputStream));
        }
    }

    public void writeIndexFile(String location, Collection<String> lines) throws IOException {
        if (location != null) {
            JarArchiveEntry entry = new JarArchiveEntry(location);
            this.writeEntry(entry, (OutputStream outputStream) -> {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
                for (String line : lines) {
                    writer.write(line);
                    writer.write("\n");
                }
                writer.flush();
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getNestedLibraryTime(Library library) {
        try (JarInputStream jarStream = new JarInputStream(library.openStream());){
            JarEntry entry = jarStream.getNextJarEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    long l = entry.getTime();
                    return l;
                }
                entry = jarStream.getNextJarEntry();
            }
            return library.getLastModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return library.getLastModified();
    }

    @Override
    public void writeLoaderClasses() throws IOException {
        this.writeLoaderClasses(LoaderImplementation.DEFAULT);
    }

    @Override
    public void writeLoaderClasses(LoaderImplementation loaderImplementation) throws IOException {
        this.writeLoaderClasses(loaderImplementation != null ? loaderImplementation.getJarResourceName() : LoaderImplementation.DEFAULT.getJarResourceName());
    }

    @Override
    public void writeLoaderClasses(String loaderJarResourceName) throws IOException {
        URL loaderJar = this.getClass().getClassLoader().getResource(loaderJarResourceName);
        try (JarInputStream inputStream = new JarInputStream(new BufferedInputStream(loaderJar.openStream()));){
            JarEntry entry;
            while ((entry = inputStream.getNextJarEntry()) != null) {
                if (!this.isDirectoryEntry(entry) && !this.isClassEntry(entry) && !this.isServicesEntry(entry)) continue;
                this.writeEntry(new JarArchiveEntry(entry), (EntryWriter)new InputStreamEntryWriter(inputStream));
            }
        }
    }

    private boolean isDirectoryEntry(JarEntry entry) {
        return entry.isDirectory() && !entry.getName().equals("META-INF/");
    }

    private boolean isClassEntry(JarEntry entry) {
        return entry.getName().endsWith(".class");
    }

    private boolean isServicesEntry(JarEntry entry) {
        return !entry.isDirectory() && entry.getName().startsWith("META-INF/services/");
    }

    private void writeEntry(JarArchiveEntry entry, EntryWriter entryWriter) throws IOException {
        this.writeEntry(entry, null, entryWriter);
    }

    private void writeEntry(JarArchiveEntry entry, Library library, EntryWriter entryWriter) throws IOException {
        String name = entry.getName();
        if (this.writtenEntries.add(name)) {
            this.writeParentDirectoryEntries(name);
            entry.setUnixMode(name.endsWith("/") ? 16877 : 33188);
            entry.getGeneralPurposeBit().useUTF8ForNames(true);
            if (!entry.isDirectory() && entry.getSize() == -1L) {
                entryWriter = SizeCalculatingEntryWriter.get(entryWriter);
                entry.setSize(entryWriter.size());
            }
            this.updateLayerIndex(entry, library);
            this.writeToArchive(entry, entryWriter);
        }
    }

    private void updateLayerIndex(JarArchiveEntry entry, Library library) {
        if (this.layers != null && !entry.getName().endsWith("/")) {
            Layer layer = library != null ? this.layers.getLayer(library) : this.layers.getLayer(entry.getName());
            this.layersIndex.add(layer, entry.getName());
        }
    }

    protected abstract void writeToArchive(ZipEntry var1, EntryWriter var2) throws IOException;

    private void writeParentDirectoryEntries(String name) throws IOException {
        String parent;
        String string = parent = name.endsWith("/") ? name.substring(0, name.length() - 1) : name;
        while (parent.lastIndexOf(47) != -1) {
            if ((parent = parent.substring(0, parent.lastIndexOf(47))).isEmpty()) continue;
            this.writeEntry(new JarArchiveEntry(parent + "/"), null, null);
        }
    }

    @FunctionalInterface
    static interface EntryTransformer {
        public static final EntryTransformer NONE = jarEntry -> jarEntry;

        public JarArchiveEntry transform(JarArchiveEntry var1);
    }

    static interface UnpackHandler {
        public static final UnpackHandler NEVER = name -> false;

        public boolean requiresUnpack(String var1);
    }

    private static class InputStreamEntryWriter
    implements EntryWriter {
        private final InputStream inputStream;

        InputStreamEntryWriter(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            int bytesRead;
            byte[] buffer = new byte[32768];
            while ((bytesRead = this.inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.flush();
        }
    }

    private static class StoredEntryPreparator {
        private static final int BUFFER_SIZE = 32768;
        private final MessageDigest messageDigest;
        private final CRC32 crc = new CRC32();
        private long size;

        StoredEntryPreparator(InputStream inputStream, boolean unpack) throws IOException {
            this.messageDigest = unpack ? StoredEntryPreparator.sha1Digest() : null;
            try (InputStream inputStream2 = inputStream;){
                this.load(inputStream);
            }
        }

        private static MessageDigest sha1Digest() {
            try {
                return MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private void load(InputStream inputStream) throws IOException {
            int bytesRead;
            byte[] buffer = new byte[32768];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                this.crc.update(buffer, 0, bytesRead);
                if (this.messageDigest != null) {
                    this.messageDigest.update(buffer, 0, bytesRead);
                }
                this.size += (long)bytesRead;
            }
        }

        void prepareStoredEntry(ZipArchiveEntry entry) {
            entry.setSize(this.size);
            entry.setCompressedSize(this.size);
            entry.setCrc(this.crc.getValue());
            entry.setMethod(0);
            if (this.messageDigest != null) {
                entry.setComment("UNPACK:" + HexFormat.of().formatHex(this.messageDigest.digest()));
            }
        }
    }

    private static final class LibraryUnpackHandler
    implements UnpackHandler {
        private final Library library;

        private LibraryUnpackHandler(Library library) {
            this.library = library;
        }

        @Override
        public boolean requiresUnpack(String name) {
            return this.library.isUnpackRequired();
        }
    }
}

