/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.runtime;

import com.fizzed.rocker.runtime.RawStringify;

public class DefaultHtmlStringify
extends RawStringify {
    @Override
    public String s(String str) {
        return DefaultHtmlStringify.escape(str);
    }

    @Override
    public String s(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return this.s(obj.toString());
    }

    public static final String escape(String str) {
        if (str == null) {
            return str;
        }
        int size = str.length();
        if (size == 0) {
            return str;
        }
        int lastPos = 0;
        StringBuilder sb = null;
        for (int pos = 0; pos < size; ++pos) {
            String r;
            char c = str.charAt(pos);
            switch (c) {
                case '\"': {
                    r = "&quot;";
                    break;
                }
                case '\'': {
                    r = "&#39;";
                    break;
                }
                case '&': {
                    r = "&amp;";
                    break;
                }
                case '<': {
                    r = "&lt;";
                    break;
                }
                case '>': {
                    r = "&gt;";
                    break;
                }
                default: {
                    r = null;
                }
            }
            if (r == null) continue;
            if (sb == null) {
                sb = new StringBuilder(size + r.length() - 1);
            }
            sb.append(str, lastPos, pos);
            sb.append(r);
            lastPos = pos + 1;
        }
        if (sb == null) {
            return str;
        }
        if (lastPos < size) {
            sb.append(str, lastPos, size);
        }
        return sb.toString();
    }
}

