/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.chain;

import io.micronaut.aop.Interceptor;
import io.micronaut.aop.InterceptorBinding;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.InvocationContext;
import io.micronaut.aop.chain.InterceptorChain;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
abstract class AbstractInterceptorChain<B, R>
implements InvocationContext<B, R> {
    protected static final Logger LOG = LoggerFactory.getLogger(InterceptorChain.class);
    protected final Interceptor<B, R>[] interceptors;
    protected final Object[] originalParameters;
    protected final int interceptorCount;
    protected volatile MutableConvertibleValues<Object> attributes;
    protected int index = 0;
    protected volatile Map<String, MutableArgumentValue<?>> parameters;

    AbstractInterceptorChain(Interceptor<B, R>[] interceptors, Object ... originalParameters) {
        this.interceptors = interceptors;
        this.interceptorCount = interceptors.length;
        this.originalParameters = originalParameters;
    }

    @Override
    @NonNull
    public Object[] getParameterValues() {
        return this.originalParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValues<Object> localAttributes = this.attributes;
        if (localAttributes == null) {
            AbstractInterceptorChain abstractInterceptorChain = this;
            synchronized (abstractInterceptorChain) {
                localAttributes = this.attributes;
                if (localAttributes == null) {
                    this.attributes = localAttributes = MutableConvertibleValues.of(new ConcurrentHashMap(5));
                }
            }
        }
        return localAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Map<String, MutableArgumentValue<?>> getParameters() {
        Map<String, MutableArgumentValue<?>> localParameters = this.parameters;
        if (localParameters == null) {
            AbstractInterceptorChain abstractInterceptorChain = this;
            synchronized (abstractInterceptorChain) {
                localParameters = this.parameters;
                if (localParameters == null) {
                    Argument<?>[] arguments = this.getArguments();
                    localParameters = new LinkedHashMap(arguments.length);
                    int i2 = 0;
                    while (i2 < arguments.length) {
                        final Argument<?> argument = arguments[i2];
                        final int finalIndex = i2++;
                        localParameters.put(argument.getName(), new MutableArgumentValue<Object>(){

                            @Override
                            public AnnotationMetadata getAnnotationMetadata() {
                                return argument.getAnnotationMetadata();
                            }

                            @Override
                            public Optional<Argument<?>> getFirstTypeVariable() {
                                return argument.getFirstTypeVariable();
                            }

                            @Override
                            public Argument[] getTypeParameters() {
                                return argument.getTypeParameters();
                            }

                            @Override
                            public Map<String, Argument<?>> getTypeVariables() {
                                return argument.getTypeVariables();
                            }

                            @Override
                            @NonNull
                            public String getName() {
                                return argument.getName();
                            }

                            @Override
                            @NonNull
                            public Class<Object> getType() {
                                return argument.getType();
                            }

                            @Override
                            public boolean equalsType(@Nullable Argument<?> other) {
                                return argument.equalsType(other);
                            }

                            @Override
                            public int typeHashCode() {
                                return argument.typeHashCode();
                            }

                            @Override
                            public Object getValue() {
                                return AbstractInterceptorChain.this.originalParameters[finalIndex];
                            }

                            @Override
                            public void setValue(Object value) {
                                AbstractInterceptorChain.this.originalParameters[finalIndex] = value;
                            }
                        });
                    }
                    localParameters = Collections.unmodifiableMap(localParameters);
                    this.parameters = localParameters;
                }
            }
        }
        return localParameters;
    }

    @Override
    public R proceed(@NonNull Interceptor from) throws RuntimeException {
        for (int i2 = 0; i2 < this.interceptors.length; ++i2) {
            Interceptor<B, R> interceptor2 = this.interceptors[i2];
            if (interceptor2 != from) continue;
            this.index = i2 + 1;
            return this.proceed();
        }
        throw new IllegalArgumentException("Argument [" + from + "] is not within the interceptor chain");
    }

    @NonNull
    protected static Collection<AnnotationValue<?>> resolveInterceptorValues(@NonNull AnnotationMetadata annotationMetadata, @NonNull InterceptorKind kind) {
        if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            List<AnnotationValue<InterceptorBinding>> declaredValues = annotationMetadata.getDeclaredMetadata().getAnnotationValuesByType(InterceptorBinding.class);
            List<AnnotationValue<InterceptorBinding>> parentValues = ((AnnotationMetadataHierarchy)annotationMetadata).getRootMetadata().getAnnotationValuesByType(InterceptorBinding.class);
            if (CollectionUtils.isNotEmpty(declaredValues) || CollectionUtils.isNotEmpty(parentValues)) {
                InterceptorKind specifiedkind;
                String annotationName;
                HashSet resolved = new HashSet(declaredValues.size() + parentValues.size());
                HashSet<String> declared = new HashSet<String>(declaredValues.size());
                for (AnnotationValue<InterceptorBinding> declaredValue : declaredValues) {
                    annotationName = declaredValue.stringValue().orElse(null);
                    if (annotationName == null || (specifiedkind = (InterceptorKind)declaredValue.enumValue("kind", InterceptorKind.class).orElse(null)) != null && !specifiedkind.equals((Object)kind)) continue;
                    if (!annotationMetadata.isRepeatableAnnotation(annotationName)) {
                        declared.add(annotationName);
                    }
                    resolved.add(declaredValue);
                }
                for (AnnotationValue<InterceptorBinding> parentValue : parentValues) {
                    annotationName = parentValue.stringValue().orElse(null);
                    if (annotationName == null || declared.contains(annotationName) || (specifiedkind = (InterceptorKind)parentValue.enumValue("kind", InterceptorKind.class).orElse(null)) != null && !specifiedkind.equals((Object)kind)) continue;
                    resolved.add(parentValue);
                }
                return resolved;
            }
            return Collections.emptyList();
        }
        List<AnnotationValue<InterceptorBinding>> bindings = annotationMetadata.getAnnotationValuesByType(InterceptorBinding.class);
        if (CollectionUtils.isNotEmpty(bindings)) {
            return bindings.stream().filter(av -> {
                if (!av.stringValue().isPresent()) {
                    return false;
                }
                InterceptorKind specifiedkind = av.enumValue("kind", InterceptorKind.class).orElse(null);
                return specifiedkind == null || specifiedkind.equals((Object)kind);
            }).collect(Collectors.toSet());
        }
        return Collections.emptyList();
    }
}

