/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.io;

import io.micronaut.core.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.grails.forge.application.Project;
import org.grails.forge.io.OutputHandler;
import org.grails.forge.template.Template;

public class ZipOutputHandler
implements OutputHandler {
    private final ZipArchiveOutputStream zipOutputStream;
    private final File zip;
    private final String directory;

    public ZipOutputHandler(Project project) throws IOException {
        File baseDirectory = new File(".").getCanonicalFile();
        Path zipPath = Paths.get(baseDirectory.getPath(), project.getName() + ".zip");
        this.zip = zipPath.toAbsolutePath().normalize().toFile();
        if (this.zip.exists()) {
            throw new IllegalArgumentException("Cannot create the project because the target zip file already exists");
        }
        this.zip.createNewFile();
        this.zipOutputStream = new ZipArchiveOutputStream(Files.newOutputStream(this.zip.toPath(), new OpenOption[0]));
        this.directory = project.getName();
    }

    public ZipOutputHandler(OutputStream outputStream) {
        this.zip = null;
        this.zipOutputStream = new ZipArchiveOutputStream(outputStream);
        this.directory = null;
    }

    public ZipOutputHandler(String projectName, OutputStream outputStream) {
        this.zip = null;
        this.zipOutputStream = new ZipArchiveOutputStream(outputStream);
        this.directory = projectName;
    }

    @Override
    public String getOutputLocation() {
        if (this.zip == null) {
            return null;
        }
        return this.zip.getAbsolutePath();
    }

    @Override
    public boolean exists(String path) {
        return false;
    }

    @Override
    public void write(String path, Template contents) throws IOException {
        ZipArchiveEntry zipEntry = new ZipArchiveEntry(this.directory != null ? StringUtils.prependUri(this.directory, path) : path);
        if (contents.isExecutable()) {
            zipEntry.setUnixMode(33261);
        }
        this.zipOutputStream.putArchiveEntry(zipEntry);
        contents.write(this.zipOutputStream);
        this.zipOutputStream.closeArchiveEntry();
    }

    @Override
    public void close() throws IOException {
        this.zipOutputStream.finish();
        this.zipOutputStream.close();
    }
}

