/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.http.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.codec.CodecProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.http.codec.HttpCodecsProperties;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;
import org.springframework.util.unit.DataSize;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration(after={JacksonAutoConfiguration.class})
@ConditionalOnClass(value={CodecConfigurer.class, WebClient.class})
public class CodecsAutoConfiguration {
    private static final MimeType[] EMPTY_MIME_TYPES = new MimeType[0];

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CodecProperties.class, HttpCodecsProperties.class})
    static class DefaultCodecsConfiguration {
        DefaultCodecsConfiguration() {
        }

        @Bean
        DefaultCodecCustomizer defaultCodecCustomizer(CodecProperties codecProperties, HttpCodecsProperties httpCodecProperties, Environment environment2) {
            return new DefaultCodecCustomizer(httpCodecProperties.isLogRequestDetails(codecProperties::isLogRequestDetails), httpCodecProperties.getMaxInMemorySize(codecProperties::getMaxInMemorySize));
        }

        static final class DefaultCodecCustomizer
        implements CodecCustomizer,
        Ordered {
            private final boolean logRequestDetails;
            private final DataSize maxInMemorySize;

            DefaultCodecCustomizer(boolean logRequestDetails, DataSize maxInMemorySize) {
                this.logRequestDetails = logRequestDetails;
                this.maxInMemorySize = maxInMemorySize;
            }

            @Override
            public void customize(CodecConfigurer configurer) {
                PropertyMapper map = PropertyMapper.get();
                CodecConfigurer.DefaultCodecs defaultCodecs = configurer.defaultCodecs();
                defaultCodecs.enableLoggingRequestDetails(this.logRequestDetails);
                map.from(this.maxInMemorySize).whenNonNull().asInt(DataSize::toBytes).to(defaultCodecs::maxInMemorySize);
            }

            @Override
            public int getOrder() {
                return 0;
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ObjectMapper.class})
    static class JacksonCodecConfiguration {
        JacksonCodecConfiguration() {
        }

        @Bean
        @Order(value=0)
        @ConditionalOnBean(value={ObjectMapper.class})
        CodecCustomizer jacksonCodecCustomizer(ObjectMapper objectMapper) {
            return configurer -> {
                CodecConfigurer.DefaultCodecs defaults = configurer.defaultCodecs();
                defaults.jackson2JsonDecoder(new Jackson2JsonDecoder(objectMapper, EMPTY_MIME_TYPES));
                defaults.jackson2JsonEncoder(new Jackson2JsonEncoder(objectMapper, EMPTY_MIME_TYPES));
            };
        }
    }
}

