/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.system;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ApplicationPid {
    private static final PosixFilePermission[] WRITE_PERMISSIONS = new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE};
    private final Long pid;

    public ApplicationPid() {
        this.pid = this.currentProcessPid();
    }

    protected ApplicationPid(Long pid) {
        this.pid = pid;
    }

    private Long currentProcessPid() {
        try {
            return ProcessHandle.current().pid();
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public boolean isAvailable() {
        return this.pid != null;
    }

    public Long toLong() {
        return this.pid;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ApplicationPid) {
            ApplicationPid other = (ApplicationPid)obj;
            return ObjectUtils.nullSafeEquals(this.pid, other.pid);
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.pid);
    }

    public String toString() {
        return this.pid != null ? String.valueOf(this.pid) : "???";
    }

    public void write(File file) throws IOException {
        Assert.state(this.pid != null, "No PID available");
        this.createParentDirectory(file);
        if (file.exists()) {
            this.assertCanOverwrite(file);
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.append(String.valueOf(this.pid));
        }
    }

    private void createParentDirectory(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    private void assertCanOverwrite(File file) throws IOException {
        if (!file.canWrite() || !this.canWritePosixFile(file)) {
            throw new FileNotFoundException(String.valueOf(file) + " (permission denied)");
        }
    }

    private boolean canWritePosixFile(File file) throws IOException {
        try {
            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]);
            for (PosixFilePermission permission : WRITE_PERMISSIONS) {
                if (!permissions.contains((Object)permission)) continue;
                return true;
            }
            return false;
        }
        catch (UnsupportedOperationException ex) {
            return true;
        }
    }
}

