/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gridkit.jvmtool.event.SimpleTagCollection;
import org.gridkit.jvmtool.event.TagCollection;

public class TagDictionary {
    private static final TagSet EMPTY = new TagSet(new SimpleTagCollection());
    private Map<TagSet, Integer> tagSetDic = new LinkedHashMap<TagSet, Integer>();
    private int limit;

    public TagDictionary(int limit) {
        this.limit = limit;
        this.tagSetDic.put(EMPTY, 0);
    }

    public int intern(TagCollection tags, TagSetEncoder encoder) {
        TagSet ts = new TagSet(tags);
        Integer id = this.tagSetDic.remove(ts);
        if (id != null) {
            this.tagSetDic.put(ts, id);
            return id;
        }
        if (this.tagSetDic.size() < this.limit) {
            id = this.tagSetDic.size();
            this.encodeTag(id, ts, encoder);
            return id;
        }
        id = this.evict();
        this.encodeTag(id, ts, encoder);
        return id;
    }

    protected int evict() {
        Iterator<Integer> it = this.tagSetDic.values().iterator();
        Integer id = it.next();
        if (id == 0) {
            id = it.next();
        }
        it.remove();
        return id;
    }

    private void encodeTag(int id, TagSet ts, TagSetEncoder encoder) {
        int baseRef = 0;
        TagSet baseSet = EMPTY;
        int minDistance = this.distance(EMPTY, ts, encoder);
        for (Map.Entry<TagSet, Integer> e : this.tagSetDic.entrySet()) {
            int d = this.distance(e.getKey(), ts, encoder);
            if (d >= minDistance) continue;
            baseSet = e.getKey();
            baseRef = e.getValue();
            minDistance = d;
        }
        this.touch(baseSet, baseRef);
        encoder.startTagSet(id, baseRef);
        this.encode(baseSet, ts, encoder);
        encoder.finishTag();
        this.tagSetDic.put(ts, id);
    }

    private void touch(TagSet baseSet, int baseRef) {
        if (baseRef != 0) {
            this.tagSetDic.remove(baseSet);
            this.tagSetDic.put(baseSet, baseRef);
        }
    }

    private int distance(TagSet base, TagSet set, TagSetEncoder encoder) {
        int cost = 0;
        int nb = 0;
        int ns = 0;
        while (nb < base.tags.length && ns < set.tags.length) {
            int c = base.tags[nb].compareTo(set.tags[ns]);
            if (c == 0) {
                ++nb;
                ++ns;
                continue;
            }
            if (c < 0) {
                cost += encoder.cost(base.tags[nb].key, base.tags[nb].tag);
                ++nb;
                continue;
            }
            cost += encoder.cost(set.tags[ns].key, set.tags[ns].tag);
            ++ns;
        }
        while (nb < base.tags.length) {
            cost += encoder.cost(base.tags[nb].key, base.tags[nb].tag);
            ++nb;
        }
        while (ns < set.tags.length) {
            cost += encoder.cost(set.tags[ns].key, set.tags[ns].tag);
            ++ns;
        }
        return cost;
    }

    private void encode(TagSet base, TagSet set, TagSetEncoder encoder) {
        int nb = 0;
        int ns = 0;
        while (nb < base.tags.length && ns < set.tags.length) {
            int c = base.tags[nb].compareTo(set.tags[ns]);
            if (c == 0) {
                ++nb;
                ++ns;
                continue;
            }
            if (c < 0) {
                this.encodeRemoveTag(base, encoder, nb);
                ++nb;
                continue;
            }
            encoder.append(set.tags[ns].key, set.tags[ns].tag);
            ++ns;
        }
        while (nb < base.tags.length) {
            this.encodeRemoveTag(base, encoder, nb);
            ++nb;
        }
        while (ns < set.tags.length) {
            encoder.append(set.tags[ns].key, set.tags[ns].tag);
            ++ns;
        }
    }

    protected void encodeRemoveTag(TagSet base, TagSetEncoder encoder, int nb) {
        boolean multikey = false;
        if (nb > 0 && base.tags[nb - 1].key.equals(base.tags[nb].key)) {
            multikey = true;
        }
        if (nb + 1 < base.tags.length && base.tags[nb + 1].key.equals(base.tags[nb].key)) {
            multikey = true;
        }
        if (multikey) {
            encoder.remove(base.tags[nb].key, base.tags[nb].tag);
        } else {
            encoder.remove(base.tags[nb].key);
        }
    }

    private static class Tag
    implements Comparable<Tag> {
        final String key;
        final String tag;

        public Tag(String key, String tag) {
            this.key = key;
            this.tag = tag;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Tag other = (Tag)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
        }

        @Override
        public int compareTo(Tag o) {
            int n = this.key.compareTo(o.key);
            if (n == 0) {
                n = this.tag.compareTo(o.tag);
            }
            return n;
        }

        public String toString() {
            return this.key + ":" + this.tag;
        }
    }

    private static class TagSet {
        final Tag[] tags;
        final int hash;

        public TagSet(TagCollection col) {
            ArrayList<Tag> buf = new ArrayList<Tag>();
            for (String key : col) {
                for (String tag : col.tagsFor(key)) {
                    buf.add(new Tag(key, tag));
                }
            }
            this.tags = buf.toArray(new Tag[buf.size()]);
            Arrays.sort(this.tags);
            this.hash = Arrays.hashCode(this.tags);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TagSet other = (TagSet)obj;
            if (this.hash != other.hash) {
                return false;
            }
            return Arrays.equals(this.tags, other.tags);
        }

        public String toString() {
            return Arrays.toString(this.tags);
        }
    }

    public static interface TagSetEncoder {
        public void startTagSet(int var1, int var2);

        public void append(String var1, String var2);

        public void remove(String var1);

        public void remove(String var1, String var2);

        public int cost(String var1, String var2);

        public void finishTag();
    }
}

