/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.BooleanValueMap;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.ProgramMap;
import com.ibm.as400.resource.RUser;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceLevel;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.resource.ResourceMetaDataTable;
import com.ibm.as400.resource.ResourcePool;
import com.ibm.as400.resource.SystemResourceList;
import com.ibm.as400.resource.UpperCaseValueMap;
import java.beans.PropertyVetoException;

public class RUserList
extends SystemResourceList {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    public static final String ALL = "*ALL";
    public static final String USER = "*USER";
    public static final String GROUP = "*GROUP";
    public static final String MEMBER = "*MEMBER";
    public static final String NONE = "*NONE";
    public static final String NOGROUP = "*NOGROUP";
    private static final String PRESENTATION_KEY_ = "USER_LIST";
    private static final String ICON_BASE_NAME_ = "RUserList";
    private static PresentationLoader presentationLoader_;
    private static ResourceMetaDataTable selections_;
    private static ProgramMap selectionMap_;
    public static final String SELECTION_CRITERIA = "SELECTION_CRITERIA";
    public static final String GROUP_PROFILE = "GROUP_PROFILE";
    public static final String USER_PROFILE = "USER_PROFILE";
    private static ProgramMap openListAttributeMap_;
    private static final String openListProgramName_ = "qgyolaus";
    private static final String DOCUMENT_NAME_ = "com.ibm.as400.resource.RUserList";
    private static ProgramCallDocument staticDocument_;
    private static final String formatName_ = "autu0150";
    private static final String profileNameDataName_ = ".receiverVariable.profileName";
    private static final String userOrGroupIndicatorDataName_ = ".receiverVariable.userOrGroupIndicator";

    public RUserList() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), RUser.attributes_, selections_, null, openListProgramName_, formatName_, selectionMap_);
    }

    public RUserList(AS400 system) {
        this();
        try {
            this.setSystem(system);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    protected void establishConnection() throws ResourceException {
        super.establishConnection();
        this.setDocument((ProgramCallDocument)staticDocument_.clone());
        this.setOpenListProgramName(openListProgramName_);
    }

    @Override
    Resource newResource(String programName, int[] indices) throws PcmlException, ResourceException {
        ProgramCallDocument document = this.getDocument();
        String name = (String)document.getValue(programName + profileNameDataName_, indices);
        AS400 system = this.getSystem();
        Object resourceKey = RUser.computeResourceKey(system, name);
        RUser resource = (RUser)ResourcePool.GLOBAL_RESOURCE_POOL.getResource(resourceKey);
        if (resource == null) {
            try {
                resource = new RUser(system, name);
                resource.setResourceKey(resourceKey);
                resource.freezeProperties();
            }
            catch (Exception e) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Exception while creating user from user list", (Throwable)e);
                }
                throw new ResourceException(e);
            }
        }
        Object[] attributeIDs = openListAttributeMap_.getIDs();
        Object[] values = openListAttributeMap_.getValues(attributeIDs, system, document, programName, indices);
        for (int i = 0; i < values.length; ++i) {
            resource.initializeAttributeValue(attributeIDs[i], values[i]);
        }
        return resource;
    }

    @Override
    void setOpenParameters(ProgramCallDocument document) throws PcmlException, ResourceException {
        String groupProfile = (String)this.getSelectionValue(GROUP_PROFILE);
        if (groupProfile != null && !groupProfile.equals(NONE) && this.getSelectionValue(SELECTION_CRITERIA) == null) {
            this.setSelectionValue(SELECTION_CRITERIA, MEMBER);
        }
        super.setOpenParameters(document);
    }

    static {
        block2: {
            presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
            selections_ = new ResourceMetaDataTable(presentationLoader_, PRESENTATION_KEY_);
            selectionMap_ = new ProgramMap();
            selections_.add(SELECTION_CRITERIA, String.class, false, new String[]{ALL, USER, GROUP, MEMBER}, ALL, true);
            selectionMap_.add(SELECTION_CRITERIA, null, "selectionCriteria");
            selections_.add(GROUP_PROFILE, String.class, false, new String[]{NONE, NOGROUP}, NONE, false);
            selectionMap_.add((Object)GROUP_PROFILE, null, "groupProfileName", new UpperCaseValueMap());
            ResourceMetaData rmd = selections_.add(USER_PROFILE, String.class, false, new String[]{ALL}, ALL, false);
            rmd.setLevel(new ResourceLevel("V5R1M0"));
            selectionMap_.add((Object)USER_PROFILE, null, "profileName", new UpperCaseValueMap());
            openListAttributeMap_ = new ProgramMap();
            openListAttributeMap_.add("USER_PROFILE_NAME", null, "receiverVariable.profileName");
            openListAttributeMap_.add((Object)"GROUP_MEMBER_INDICATOR", null, "receiverVariable.userOrGroupIndicator", new BooleanValueMap("0", "1"));
            openListAttributeMap_.add("TEXT_DESCRIPTION", null, "receiverVariable.textDescription");
            staticDocument_ = null;
            try {
                staticDocument_ = new ProgramCallDocument();
                staticDocument_.setDocument(DOCUMENT_NAME_);
            }
            catch (PcmlException e) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Error instantiating ProgramCallDocument", (Throwable)e);
            }
        }
    }
}

