/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.writetolog;

import java.util.Date;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;

@Action(id="WRITE_TO_LOG", name="i18n::ActionWriteToLog.Name", description="i18n::ActionWriteToLog.Description", image="WriteToLog.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", keywords={"i18n::ActionWriteToLog.keyword"}, documentationUrl="/workflow/actions/writetolog.html")
public class ActionWriteToLog
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionWriteToLog.class;
    @HopMetadataProperty(key="loglevel", storeWithCode=true)
    private LogLevel actionLogLevel = LogLevel.BASIC;
    @HopMetadataProperty(key="logsubject")
    private String logSubject = null;
    @HopMetadataProperty(key="logmessage")
    private String logMessage = null;

    public ActionWriteToLog(String n) {
        super(n, "");
    }

    public ActionWriteToLog() {
        this("");
    }

    public Object clone() {
        ActionWriteToLog action = (ActionWriteToLog)super.clone();
        return action;
    }

    protected ILogChannel createLogChannel() {
        String subject = Const.nullToEmpty((String)this.resolve(this.getLogSubject()));
        LogWriterObject logWriterObject = new LogWriterObject(subject, (ILoggingObject)this, this.parentWorkflow.getLogLevel());
        return logWriterObject.getLogChannel();
    }

    public boolean evaluate(Result result) {
        ILogChannel logChannel = this.createLogChannel();
        String message = Const.nullToEmpty((String)this.resolve(this.getLogMessage()));
        if (Utils.isEmpty((CharSequence)message) || !this.getActionLogLevel().isVisible(logChannel.getLogLevel())) {
            return true;
        }
        try {
            switch (this.getActionLogLevel()) {
                case ERROR: {
                    logChannel.logError(message + Const.CR);
                    break;
                }
                case MINIMAL: {
                    logChannel.logMinimal(message + Const.CR);
                    break;
                }
                case BASIC: {
                    logChannel.logBasic(message + Const.CR);
                    break;
                }
                case DETAILED: {
                    logChannel.logDetailed(message + Const.CR);
                    break;
                }
                case DEBUG: {
                    logChannel.logDebug(message + Const.CR);
                    break;
                }
                case ROWLEVEL: {
                    logChannel.logRowlevel(message + Const.CR);
                    break;
                }
            }
            return true;
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"WriteToLog.Error.Label", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"WriteToLog.Error.Description", (String[])new String[0]) + " : " + e.toString()});
            return false;
        }
    }

    public Result execute(Result prevResult, int nr) {
        prevResult.setResult(this.evaluate(prevResult));
        return prevResult;
    }

    public boolean resetErrorsBeforeExecution() {
        return false;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public String getLogMessage() {
        if (this.logMessage == null) {
            this.logMessage = "";
        }
        return this.logMessage;
    }

    public String getLogSubject() {
        if (this.logSubject == null) {
            this.logSubject = "";
        }
        return this.logSubject;
    }

    public void setLogMessage(String message) {
        this.logMessage = message;
    }

    public void setLogSubject(String subject) {
        this.logSubject = subject;
    }

    public LogLevel getActionLogLevel() {
        return this.actionLogLevel;
    }

    public void setActionLogLevel(LogLevel level) {
        this.actionLogLevel = level;
    }

    private class LogWriterObject
    implements ILoggingObject {
        private ILogChannel log;
        private LogLevel logLevel;
        private ILoggingObject parent;
        private String subject;
        private String containerObjectId;

        public LogWriterObject(String subject, ILoggingObject parent, LogLevel logLevel) {
            this.subject = subject;
            this.parent = parent;
            this.logLevel = logLevel;
            this.log = new LogChannel((Object)this, parent);
            this.containerObjectId = this.log.getContainerObjectId();
        }

        public String getFilename() {
            return null;
        }

        public String getLogChannelId() {
            return this.log.getLogChannelId();
        }

        public String getObjectCopy() {
            return null;
        }

        public String getObjectName() {
            return this.subject;
        }

        public LoggingObjectType getObjectType() {
            return LoggingObjectType.ACTION;
        }

        public ILoggingObject getParent() {
            return this.parent;
        }

        public ILogChannel getLogChannel() {
            return this.log;
        }

        public LogLevel getLogLevel() {
            return this.logLevel;
        }

        public String getContainerId() {
            return this.containerObjectId;
        }

        public Date getRegistrationDate() {
            return null;
        }

        public boolean isGatheringMetrics() {
            return this.parent.isGatheringMetrics();
        }

        public void setGatheringMetrics(boolean gatheringMetrics) {
            this.parent.setGatheringMetrics(gatheringMetrics);
        }

        public boolean isForcingSeparateLogging() {
            return this.parent.isForcingSeparateLogging();
        }

        public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
            this.parent.setForcingSeparateLogging(forcingSeparateLogging);
        }
    }
}

