/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress.hadoopsnappy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.hop.core.compress.CompressionPlugin;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.compress.hadoopsnappy.HadoopSnappyCompressionInputStream;
import org.apache.hop.core.compress.hadoopsnappy.HadoopSnappyCompressionOutputStream;

@CompressionPlugin(id="HADOOPSNAPPY", name="Hadoop-snappy", description="Hadoop Snappy compression")
public class HadoopSnappyCompressionProvider
implements ICompressionProvider {
    public static final int IO_COMPRESSION_CODEC_SNAPPY_DEFAULT_BUFFERSIZE = 262144;
    private static final String HADOOP_CONFIG_UTIL_CLASS_PROPERTY = "hadoop.config.util.class";
    private static final String[] HADOOP_CONFIG_UTIL_CLASS = new String[]{"org.apache.hadoop.hive.jdbc.HadoopConfigurationUtil", "org.apache.hop.hadoop.hive.jdbc.HadoopConfigurationUtil"};
    private static final String GET_ACTIVE_CONFIGURATION_METHOD = "getActiveConfiguration";
    private static final String GET_SNAPPY_SHIM = "getSnappyShim";

    public static Object getActiveSnappyShim() throws Exception {
        Class<?> hadoopConfigUtilClass = null;
        String hadoopConfigUtilClassName = System.getProperty(HADOOP_CONFIG_UTIL_CLASS_PROPERTY);
        if (hadoopConfigUtilClassName != null) {
            hadoopConfigUtilClass = Class.forName(hadoopConfigUtilClassName);
        } else {
            for (int i = 0; hadoopConfigUtilClass == null && i < HADOOP_CONFIG_UTIL_CLASS.length; ++i) {
                try {
                    hadoopConfigUtilClass = Class.forName(HADOOP_CONFIG_UTIL_CLASS[i]);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (hadoopConfigUtilClass == null) {
                throw new Exception("No Hadoop Configuration Utilities class found, unable to get active Snappy shim");
            }
        }
        Method getActiveConfiguration = hadoopConfigUtilClass.getMethod(GET_ACTIVE_CONFIGURATION_METHOD, new Class[0]);
        Object hadoopConfiguration = getActiveConfiguration.invoke(hadoopConfigUtilClass.newInstance(), new Object[0]);
        Method getSnappyShim = hadoopConfiguration.getClass().getMethod(GET_SNAPPY_SHIM, new Class[0]);
        return getSnappyShim.invoke(hadoopConfiguration, new Object[0]);
    }

    public static boolean isHadoopSnappyAvailable() {
        try {
            Object snappyShim = HadoopSnappyCompressionProvider.getActiveSnappyShim();
            Method m = snappyShim.getClass().getMethod("isHadoopSnappyAvailable", new Class[0]);
            return (Boolean)m.invoke(snappyShim, new Object[0]);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public HadoopSnappyCompressionInputStream createInputStream(InputStream in) throws IOException {
        return new HadoopSnappyCompressionInputStream(in, this);
    }

    @Override
    public boolean supportsInput() {
        return true;
    }

    @Override
    public HadoopSnappyCompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new HadoopSnappyCompressionOutputStream(out, this);
    }

    @Override
    public boolean supportsOutput() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Hadoop Snappy compression";
    }

    @Override
    public String getName() {
        return "Hadoop-snappy";
    }

    @Override
    public String getDefaultExtension() {
        return null;
    }
}

