/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheStats;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class CachedSideInputReader
implements SideInputReader {
    private final @UnknownKeyFor @NonNull @Initialized SideInputReader reader;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized Object>> caches;

    public static @UnknownKeyFor @NonNull @Initialized SideInputReader of(@UnknownKeyFor @NonNull @Initialized SideInputReader reader, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> views) {
        Map<PCollectionView<?>, Cache<BoundedWindow, Object>> caches = CachedSideInputReader.initCaches(views, 1000);
        return caches.isEmpty() ? reader : new CachedSideInputReader(reader, caches);
    }

    private CachedSideInputReader(@UnknownKeyFor @NonNull @Initialized SideInputReader reader, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized Object>> caches) {
        this.reader = reader;
        this.caches = caches;
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized Object>> initCaches(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> views, @UnknownKeyFor @NonNull @Initialized int maxSize) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PCollectionView<?> view : views) {
            if (!CachedSideInputReader.shouldCache(view)) continue;
            boolean isGlobal = view.getWindowingStrategyInternal().getWindowFn() instanceof GlobalWindows;
            builder.put(view, isGlobal ? new Cache<BoundedWindow, Object>() : CachedSideInputReader.lruCache(maxSize));
        }
        return builder.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean shouldCache(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view) {
        return "beam:side_input:multimap:v1".equals(view.getViewFn().getMaterialization().getUrn());
    }

    private static @UnknownKeyFor @NonNull @Initialized Cache<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized Object> lruCache(@UnknownKeyFor @NonNull @Initialized int maxSize) {
        return CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize((long)maxSize).build();
    }

    public <T> @Nullable T get(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        Object result;
        Cache<BoundedWindow, Object> cache = this.caches.get(view);
        if (cache != null && (result = cache.getIfPresent((Object)window)) == null) {
            result = this.reader.get(view, window);
            if (result != null) {
                cache.put((Object)window, result);
            }
            return (T)result;
        }
        return (T)this.reader.get(view, window);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized boolean contains(@UnknownKeyFor @NonNull @Initialized PCollectionView<T> view) {
        return this.reader.contains(view);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
        return this.reader.isEmpty();
    }

    private static class SingletonCache<@UnknownKeyFor K, @UnknownKeyFor V>
    implements Cache<K, V> {
        private @Nullable V value;

        private SingletonCache() {
        }

        public @Nullable V getIfPresent(@UnknownKeyFor @NonNull @Initialized Object o) {
            return this.value;
        }

        public void put(K k, V v) {
            this.value = v;
        }

        public @UnknownKeyFor @NonNull @Initialized long size() {
            return this.value != null ? 1L : 0L;
        }

        public V get(K k, @UnknownKeyFor @NonNull @Initialized Callable<@KeyForBottom @NonNull @Initialized ? extends V> callable) throws @UnknownKeyFor @NonNull @Initialized ExecutionException {
            throw new UnsupportedOperationException();
        }

        public @UnknownKeyFor @NonNull @Initialized ImmutableMap<K, V> getAllPresent(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> iterable) {
            throw new UnsupportedOperationException();
        }

        public void putAll(@UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends K, @KeyForBottom @NonNull @Initialized ? extends V> map) {
            throw new UnsupportedOperationException();
        }

        public void invalidate(@UnknownKeyFor @NonNull @Initialized Object o) {
        }

        public void invalidateAll(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> iterable) {
        }

        public void invalidateAll() {
        }

        public @UnknownKeyFor @NonNull @Initialized CacheStats stats() {
            throw new UnsupportedOperationException();
        }

        public @UnknownKeyFor @NonNull @Initialized ConcurrentMap<K, V> asMap() {
            throw new UnsupportedOperationException();
        }

        public void cleanUp() {
            this.value = null;
        }
    }
}

