/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library.cdt;

import java.util.List;
import java.util.Map;
import org.apache.jena.cdt.CDTKey;
import org.apache.jena.cdt.CDTValue;
import org.apache.jena.cdt.CompositeDatatypeList;
import org.apache.jena.cdt.CompositeDatatypeMap;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;

public class CDTLiteralFunctionUtils {
    public static final void ensureListLiteral(Node n) throws ExprEvalException {
        if (!CompositeDatatypeList.isListLiteral(n)) {
            throw new ExprEvalException("Not a cdt:List literal: " + String.valueOf(n));
        }
    }

    public static final void ensureMapLiteral(Node n) throws ExprEvalException {
        if (!CompositeDatatypeMap.isMapLiteral(n)) {
            throw new ExprEvalException("Not a cdt:Map literal: " + String.valueOf(n));
        }
    }

    public static final List<CDTValue> getList(Node n) throws ExprEvalException {
        if (!n.getLiteral().isWellFormed()) {
            throw new ExprEvalException("Not a well-formed cdt:Map literal: " + String.valueOf(n));
        }
        try {
            return CompositeDatatypeList.getValue(n.getLiteral());
        }
        catch (DatatypeFormatException ex) {
            throw new ExprEvalException("Not a well-formed cdt:List literal: " + String.valueOf(n), ex);
        }
    }

    public static final Map<CDTKey, CDTValue> getMap(Node n) throws ExprEvalException {
        if (!n.getLiteral().isWellFormed()) {
            throw new ExprEvalException("Not a well-formed cdt:Map literal: " + String.valueOf(n));
        }
        try {
            return CompositeDatatypeMap.getValue(n.getLiteral());
        }
        catch (DatatypeFormatException ex) {
            throw new ExprEvalException("Not a well-formed cdt:Map literal: " + String.valueOf(n), ex);
        }
    }

    public static final List<CDTValue> checkAndGetList(Node n) throws ExprEvalException {
        CDTLiteralFunctionUtils.ensureListLiteral(n);
        return CDTLiteralFunctionUtils.getList(n);
    }

    public static final Map<CDTKey, CDTValue> checkAndGetMap(Node n) throws ExprEvalException {
        CDTLiteralFunctionUtils.ensureMapLiteral(n);
        return CDTLiteralFunctionUtils.getMap(n);
    }

    public static final List<CDTValue> checkAndGetList(NodeValue nv) throws ExprEvalException {
        return CDTLiteralFunctionUtils.checkAndGetList(nv.asNode());
    }

    public static final Map<CDTKey, CDTValue> checkAndGetMap(NodeValue nv) throws ExprEvalException {
        return CDTLiteralFunctionUtils.checkAndGetMap(nv.asNode());
    }

    public static final Node createNode(List<CDTValue> list) {
        return NodeFactory.createLiteralByValue(list, CompositeDatatypeList.datatype());
    }

    public static final Node createNode(Map<CDTKey, CDTValue> map) {
        return NodeFactory.createLiteralByValue(map, CompositeDatatypeMap.datatype());
    }

    public static final NodeValue createNodeValue(List<CDTValue> list) {
        return NodeValue.makeNode(CDTLiteralFunctionUtils.createNode(list));
    }

    public static final NodeValue createNodeValue(Map<CDTKey, CDTValue> map) {
        return NodeValue.makeNode(CDTLiteralFunctionUtils.createNode(map));
    }
}

