/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.shared.JenaException;

public class JenaXMLOutput {
    private static TransformerFactory xmlTransformerFactory = JenaXMLOutput.xmlTransformerFactory();

    public static Transformer xmlTransformer() {
        try {
            return xmlTransformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            Log.error(JenaXMLOutput.class, "Failed to build a javax.xml.transform.Transformer", ex);
            throw new JenaException(ex);
        }
    }

    private static TransformerFactory xmlTransformerFactory() {
        try {
            TransformerFactory xmlTransformerFactory = TransformerFactory.newInstance();
            xmlTransformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            JenaXMLOutput.attempt(() -> xmlTransformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", ""));
            JenaXMLOutput.attempt(() -> xmlTransformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", ""));
            return xmlTransformerFactory;
        }
        catch (TransformerConfigurationException ex) {
            Log.error(JenaXMLOutput.class, "Failed to build a javax.xml.transform.TransformerFactory", ex);
            return null;
        }
    }

    private static void attempt(Runnable action) {
        try {
            action.run();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

