/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.SpatialQuery;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.Geometry;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;

abstract class ShapeDocValues {
    protected static final byte VERSION = 0;
    private final BytesRef data;
    protected final ShapeComparator shapeComparator;
    protected final Geometry centroid;
    protected final Geometry boundingBox;

    ShapeDocValues(List<ShapeField.DecodedTriangle> tessellation) {
        this.data = this.computeBinaryValue(tessellation);
        try {
            this.shapeComparator = new ShapeComparator(this, this.data);
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("unable to read binary shape doc value field. ", e2);
        }
        this.centroid = this.computeCentroid();
        this.boundingBox = this.computeBoundingBox();
    }

    ShapeDocValues(BytesRef binaryValue) {
        this.data = binaryValue;
        try {
            this.shapeComparator = new ShapeComparator(this, this.data);
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("unable to read binary shape doc value field. ", e2);
        }
        this.centroid = this.computeCentroid();
        this.boundingBox = this.computeBoundingBox();
    }

    protected BytesRef binaryValue() {
        return this.data;
    }

    public int numberOfTerms() {
        return this.shapeComparator.numberOfTerms();
    }

    public int getEncodedMinX() {
        return this.shapeComparator.getMinX();
    }

    public int getEncodedMinY() {
        return this.shapeComparator.getMinY();
    }

    public int getEncodedMaxX() {
        return this.shapeComparator.getMaxX();
    }

    public int getEncodedMaxY() {
        return this.shapeComparator.getMaxY();
    }

    protected int getEncodedCentroidX() {
        return this.shapeComparator.getCentroidX();
    }

    protected int getEncodedCentroidY() {
        return this.shapeComparator.getCentroidY();
    }

    public ShapeField.DecodedTriangle.TYPE getHighestDimension() {
        return this.shapeComparator.getHighestDimension();
    }

    private BytesRef computeBinaryValue(List<ShapeField.DecodedTriangle> tessellation) {
        try {
            ArrayList<TreeNode> dfsSerialized = new ArrayList<TreeNode>(tessellation.size());
            this.buildTree(tessellation, dfsSerialized);
            Writer w = new Writer(dfsSerialized);
            return w.getBytesRef();
        }
        catch (IOException e2) {
            throw new RuntimeException("Internal error building LatLonShapeDocValues. Got ", e2);
        }
    }

    public static Query newGeometryQuery(String field, ShapeField.QueryRelation relation, Object ... geometries) {
        return null;
    }

    public PointValues.Relation relate(Component2D component) throws IOException {
        return this.shapeComparator.relate(component);
    }

    protected abstract Encoder getEncoder();

    protected abstract Geometry computeCentroid();

    protected abstract Geometry computeBoundingBox();

    public abstract Geometry getCentroid();

    public abstract Geometry getBoundingBox();

    private TreeNode buildTree(List<ShapeField.DecodedTriangle> tessellation, List<TreeNode> dfsSerialized) throws IOException {
        if (tessellation.size() == 1) {
            ShapeField.DecodedTriangle t = tessellation.get(0);
            TreeNode node = new TreeNode(this, t);
            if (t.type == ShapeField.DecodedTriangle.TYPE.LINE) {
                if (node.length != 0.0) {
                    node.midX /= node.length;
                    node.midY /= node.length;
                }
            } else if (t.type == ShapeField.DecodedTriangle.TYPE.TRIANGLE && node.signedArea != 0.0) {
                node.midX /= node.signedArea;
                node.midY /= node.signedArea;
            }
            node.highestType = t.type;
            dfsSerialized.add(node);
            return node;
        }
        TreeNode[] triangles = new TreeNode[tessellation.size()];
        int i = 0;
        int minY = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxX = Integer.MIN_VALUE;
        double totalSignedArea = 0.0;
        double totalLength = 0.0;
        double numXPnt = 0.0;
        double numYPnt = 0.0;
        double numXLin = 0.0;
        double numYLin = 0.0;
        double numXPly = 0.0;
        double numYPly = 0.0;
        ShapeField.DecodedTriangle.TYPE highestType = ShapeField.DecodedTriangle.TYPE.POINT;
        for (ShapeField.DecodedTriangle t : tessellation) {
            TreeNode node = new TreeNode(this, t);
            triangles[i++] = node;
            minY = Math.min(minY, node.minY);
            minX = Math.min(minX, node.minX);
            maxY = Math.max(maxY, node.maxY);
            maxX = Math.max(maxX, node.maxX);
            totalSignedArea += node.signedArea;
            totalLength += node.length;
            if (t.type == ShapeField.DecodedTriangle.TYPE.POINT) {
                numXPnt += node.midX;
                numYPnt += node.midY;
                continue;
            }
            if (t.type == ShapeField.DecodedTriangle.TYPE.LINE) {
                if (highestType == ShapeField.DecodedTriangle.TYPE.POINT) {
                    highestType = ShapeField.DecodedTriangle.TYPE.LINE;
                }
                numXLin += node.midX;
                numYLin += node.midY;
                continue;
            }
            if (highestType != ShapeField.DecodedTriangle.TYPE.TRIANGLE) {
                highestType = ShapeField.DecodedTriangle.TYPE.TRIANGLE;
            }
            numXPly += node.midX;
            numYPly += node.midY;
        }
        TreeNode root2 = this.createTree(triangles, 0, triangles.length - 1, false, null, dfsSerialized);
        root2.minY = minY;
        root2.minX = minX;
        root2.highestType = highestType;
        if (highestType == ShapeField.DecodedTriangle.TYPE.POINT) {
            root2.midX = numXPnt / (double)i;
            root2.midY = numYPnt / (double)i;
        } else if (highestType == ShapeField.DecodedTriangle.TYPE.LINE) {
            root2.midX = numXLin;
            root2.midY = numYLin;
            if (totalLength != 0.0) {
                root2.midX /= totalLength;
                root2.midY /= totalLength;
            }
        } else {
            root2.midX = numXPly;
            root2.midY = numYPly;
            if (totalSignedArea != 0.0) {
                root2.midX /= totalSignedArea;
                root2.midY /= totalSignedArea;
            }
        }
        return root2;
    }

    private TreeNode createTree(TreeNode[] triangles, int low, int high, boolean splitX, TreeNode parent, List<TreeNode> dfsSerialized) {
        if (low > high) {
            return null;
        }
        int mid = low + high >>> 1;
        if (low < high) {
            Comparator<TreeNode> comparator = splitX ? Comparator.comparingInt(left -> left.minX).thenComparingInt(left -> left.maxX) : Comparator.comparingInt(left -> left.minY).thenComparingInt(left -> left.maxY);
            ArrayUtil.select(triangles, low, high + 1, mid, comparator);
        }
        TreeNode newNode = triangles[mid];
        dfsSerialized.add(newNode);
        newNode.parent = parent;
        newNode.left = this.createTree(triangles, low, mid - 1, !splitX, newNode, dfsSerialized);
        newNode.right = this.createTree(triangles, mid + 1, high, !splitX, newNode, dfsSerialized);
        if (newNode.left != null) {
            newNode.minX = Math.min(newNode.minX, newNode.left.minX);
            newNode.minY = Math.min(newNode.minY, newNode.left.minY);
            newNode.maxX = Math.max(newNode.maxX, newNode.left.maxX);
            newNode.maxY = Math.max(newNode.maxY, newNode.left.maxY);
        }
        if (newNode.right != null) {
            newNode.minX = Math.min(newNode.minX, newNode.right.minX);
            newNode.minY = Math.min(newNode.minY, newNode.right.minY);
            newNode.maxX = Math.max(newNode.maxX, newNode.right.maxX);
            newNode.maxY = Math.max(newNode.maxY, newNode.right.maxY);
        }
        if (newNode.left != null) {
            newNode.left.byteSize += ShapeDocValues.vLongSize((long)newNode.maxX - (long)newNode.left.minX);
            newNode.left.byteSize += ShapeDocValues.vLongSize((long)newNode.maxY - (long)newNode.left.minY);
            newNode.left.byteSize += ShapeDocValues.vLongSize((long)newNode.maxX - (long)newNode.left.maxX);
            newNode.left.byteSize += ShapeDocValues.vLongSize((long)newNode.maxY - (long)newNode.left.maxY);
            newNode.left.byteSize += this.computeComponentSize(newNode.left, newNode.maxX, newNode.maxY);
            newNode.byteSize += ShapeDocValues.vIntSize(newNode.left.byteSize) + newNode.left.byteSize;
        }
        if (newNode.right != null) {
            newNode.right.byteSize += ShapeDocValues.vLongSize((long)newNode.maxX - (long)newNode.right.minX);
            newNode.right.byteSize += ShapeDocValues.vLongSize((long)newNode.maxY - (long)newNode.right.minY);
            newNode.right.byteSize += ShapeDocValues.vLongSize((long)newNode.maxX - (long)newNode.right.maxX);
            newNode.right.byteSize += ShapeDocValues.vLongSize((long)newNode.maxY - (long)newNode.right.maxY);
            newNode.right.byteSize += this.computeComponentSize(newNode.right, newNode.maxX, newNode.maxY);
            newNode.byteSize += ShapeDocValues.vIntSize(newNode.right.byteSize) + newNode.right.byteSize;
        }
        return newNode;
    }

    private int computeComponentSize(TreeNode node, int maxX, int maxY) {
        int size = 0;
        ShapeField.DecodedTriangle t = node.triangle;
        size += ShapeDocValues.vLongSize((long)maxX - (long)t.aX);
        size += ShapeDocValues.vLongSize((long)maxY - (long)t.aY);
        if (t.type == ShapeField.DecodedTriangle.TYPE.LINE || t.type == ShapeField.DecodedTriangle.TYPE.TRIANGLE) {
            size += ShapeDocValues.vLongSize((long)maxX - (long)t.bX);
            size += ShapeDocValues.vLongSize((long)maxY - (long)t.bY);
        }
        if (t.type == ShapeField.DecodedTriangle.TYPE.TRIANGLE) {
            size += ShapeDocValues.vLongSize((long)maxX - (long)t.cX);
            size += ShapeDocValues.vLongSize((long)maxY - (long)t.cY);
        }
        return size;
    }

    protected static int vLongSize(long i) {
        int size = 0;
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            i >>>= 7;
            ++size;
        }
        return ++size;
    }

    protected static int vIntSize(int i) {
        int size = 0;
        while ((i & 0xFFFFFF80) != 0) {
            i >>>= 7;
            ++size;
        }
        return ++size;
    }

    private final class ShapeComparator {
        private Reader dvReader;
        private final Encoder encoder;
        private final byte version;
        private final int numberOfTerms;
        private final SpatialQuery.EncodedRectangle boundingBox;
        private final int centroidX;
        private final int centroidY;
        private final ShapeField.DecodedTriangle.TYPE highestDimension;

        ShapeComparator(ShapeDocValues shapeDocValues, BytesRef binaryValue) throws IOException {
            this.dvReader = shapeDocValues.new Reader(binaryValue);
            this.encoder = shapeDocValues.getEncoder();
            this.version = this.dvReader.readByte();
            assert (this.version == 0);
            this.numberOfTerms = Math.toIntExact(this.dvReader.readVInt());
            this.boundingBox = this.dvReader.readBBox();
            this.centroidX = Math.toIntExact(this.dvReader.readVLong() + Integer.MIN_VALUE);
            this.centroidY = Math.toIntExact(this.dvReader.readVLong() + Integer.MIN_VALUE);
            this.highestDimension = ShapeField.DecodedTriangle.TYPE.values()[this.dvReader.readVInt()];
            this.dvReader.rewind();
        }

        private int numberOfTerms() {
            return this.numberOfTerms;
        }

        private int getMinX() {
            return this.boundingBox.minX;
        }

        private int getMinY() {
            return this.boundingBox.minY;
        }

        private int getMaxX() {
            return this.boundingBox.maxX;
        }

        private int getMaxY() {
            return this.boundingBox.maxY;
        }

        public ShapeField.DecodedTriangle.TYPE getHighestDimension() {
            return this.highestDimension;
        }

        private int getCentroidX() {
            return this.centroidX;
        }

        private int getCentroidY() {
            return this.centroidY;
        }

        private void skipCentroid() throws IOException {
            this.dvReader.readVLong();
            this.dvReader.readVLong();
        }

        private void skipHighestDimension() throws IOException {
            this.dvReader.readVInt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PointValues.Relation relate(Component2D query2) throws IOException {
            try {
                this.dvReader.readByte();
                this.dvReader.readVInt();
                SpatialQuery.EncodedRectangle bbox = this.dvReader.readBBox();
                int tMinX = bbox.minX;
                int tMaxX = bbox.maxX;
                int tMaxY = bbox.maxY;
                PointValues.Relation r = query2.relate(this.encoder.decodeX(bbox.minX), this.encoder.decodeX(bbox.maxX), this.encoder.decodeY(bbox.minY), this.encoder.decodeY(bbox.maxY));
                if (r != PointValues.Relation.CELL_CROSSES_QUERY) {
                    PointValues.Relation relation = r;
                    return relation;
                }
                this.skipCentroid();
                this.skipHighestDimension();
                int headerBits = Math.toIntExact(this.dvReader.readVInt());
                int x = Math.toIntExact((long)tMaxX - this.dvReader.readVLong());
                if (this.relateComponent(Reader.Header.readType(headerBits), bbox, tMaxX, tMaxY, this.encoder.decodeX(x), query2) == PointValues.Relation.CELL_CROSSES_QUERY) {
                    PointValues.Relation relation = PointValues.Relation.CELL_CROSSES_QUERY;
                    return relation;
                }
                r = PointValues.Relation.CELL_OUTSIDE_QUERY;
                if (Reader.Header.readHasLeftSubtree(headerBits) && (r = this.relate(query2, false, tMaxX, tMaxY, Math.toIntExact(this.dvReader.readVInt()))) == PointValues.Relation.CELL_CROSSES_QUERY) {
                    PointValues.Relation relation = PointValues.Relation.CELL_CROSSES_QUERY;
                    return relation;
                }
                if (Reader.Header.readHasRightSubtree(headerBits) && query2.getMaxX() >= this.encoder.decodeX(tMinX) && (r = this.relate(query2, false, tMaxX, tMaxY, Math.toIntExact(this.dvReader.readVInt()))) == PointValues.Relation.CELL_CROSSES_QUERY) {
                    PointValues.Relation relation = PointValues.Relation.CELL_CROSSES_QUERY;
                    return relation;
                }
                PointValues.Relation relation = r;
                return relation;
            }
            finally {
                this.dvReader.rewind();
            }
        }

        private PointValues.Relation relate(Component2D queryComponent2D, boolean splitX, int pMaxX, int pMaxY, int nodeSize) throws IOException {
            int prePos = this.dvReader.data.getPosition();
            int tMinX = Math.toIntExact((long)pMaxX - this.dvReader.readVLong());
            int tMinY = Math.toIntExact((long)pMaxY - this.dvReader.readVLong());
            int tMaxX = Math.toIntExact((long)pMaxX - this.dvReader.readVLong());
            int tMaxY = Math.toIntExact((long)pMaxY - this.dvReader.readVLong());
            int headerBits = Math.toIntExact(this.dvReader.readVInt());
            nodeSize -= this.dvReader.data.getPosition() - prePos;
            if (queryComponent2D.getMinX() > this.encoder.decodeX(tMaxX) || queryComponent2D.getMinY() > this.encoder.decodeY(tMaxY)) {
                this.dvReader.skipBytes(nodeSize);
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            int x = Math.toIntExact((long)pMaxX - this.dvReader.readVLong());
            SpatialQuery.EncodedRectangle bbox = this.dvReader.resetBBox(tMinX, tMaxX, tMinY, tMaxY);
            if (this.relateComponent(Reader.Header.readType(headerBits), bbox, pMaxX, pMaxY, this.encoder.decodeX(x), queryComponent2D) == PointValues.Relation.CELL_CROSSES_QUERY) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (Reader.Header.readHasLeftSubtree(headerBits) && this.relate(queryComponent2D, !splitX, tMaxX, tMaxY, Math.toIntExact(this.dvReader.readVInt())) == PointValues.Relation.CELL_CROSSES_QUERY) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (Reader.Header.readHasRightSubtree(headerBits)) {
                int size = Math.toIntExact(this.dvReader.readVInt());
                if (!splitX && queryComponent2D.getMaxY() >= this.encoder.decodeY(tMinY) || splitX && queryComponent2D.getMaxX() >= this.encoder.decodeX(tMinX)) {
                    if (this.relate(queryComponent2D, !splitX, tMaxX, tMaxY, size) == PointValues.Relation.CELL_CROSSES_QUERY) {
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                } else {
                    this.dvReader.skipBytes(size);
                }
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }

        private PointValues.Relation relateComponent(ShapeField.DecodedTriangle.TYPE type, SpatialQuery.EncodedRectangle bbox, int pMaxX, int pMaxY, double x, Component2D queryComponent2D) throws IOException {
            PointValues.Relation r = PointValues.Relation.CELL_OUTSIDE_QUERY;
            if (type == ShapeField.DecodedTriangle.TYPE.POINT) {
                r = this.relatePoint(bbox, pMaxY, x, queryComponent2D);
            } else if (type == ShapeField.DecodedTriangle.TYPE.LINE) {
                r = this.relateLine(bbox, pMaxX, pMaxY, x, queryComponent2D);
            } else if (type == ShapeField.DecodedTriangle.TYPE.TRIANGLE) {
                r = this.relateTriangle(bbox, pMaxX, pMaxY, x, queryComponent2D);
            }
            if (r == PointValues.Relation.CELL_CROSSES_QUERY) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }

        private PointValues.Relation relatePoint(SpatialQuery.EncodedRectangle bbox, int pMaxY, double ax, Component2D query2) throws IOException {
            int y = Math.toIntExact((long)pMaxY - this.dvReader.readVLong());
            if (query2.contains(ax, this.encoder.decodeY(y))) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }

        private PointValues.Relation relateLine(SpatialQuery.EncodedRectangle bbox, int pMaxX, int pMaxY, double ax, Component2D query2) throws IOException {
            int ay = Math.toIntExact((long)pMaxY - this.dvReader.readVLong());
            double bx = this.encoder.decodeX(Math.toIntExact((long)pMaxX - this.dvReader.readVLong()));
            int by = Math.toIntExact((long)pMaxY - this.dvReader.readVLong());
            if (query2.intersectsLine(ax, this.encoder.decodeY(ay), bx, this.encoder.decodeY(by))) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }

        private PointValues.Relation relateTriangle(SpatialQuery.EncodedRectangle bbox, int pMaxX, int pMaxY, double ax, Component2D queryComponent2D) throws IOException {
            int ay = Math.toIntExact((long)pMaxY - this.dvReader.readVLong());
            double bx = this.encoder.decodeX(Math.toIntExact((long)pMaxX - this.dvReader.readVLong()));
            int by = Math.toIntExact((long)pMaxY - this.dvReader.readVLong());
            double cx = this.encoder.decodeX(Math.toIntExact((long)pMaxX - this.dvReader.readVLong()));
            int cy = Math.toIntExact((long)pMaxY - this.dvReader.readVLong());
            if (queryComponent2D.intersectsTriangle(ax, this.encoder.decodeY(ay), bx, this.encoder.decodeY(by), cx, this.encoder.decodeY(cy))) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
    }

    private final class TreeNode {
        private final ShapeField.DecodedTriangle triangle;
        private double midX;
        private double midY;
        private final double signedArea;
        private final double length;
        private ShapeField.DecodedTriangle.TYPE highestType;
        private int minX;
        private int maxX;
        private int minY;
        private int maxY;
        private TreeNode left;
        private TreeNode right;
        private TreeNode parent;
        private int byteSize = 1;

        private TreeNode(ShapeDocValues shapeDocValues, ShapeField.DecodedTriangle t) {
            this.minX = StrictMath.min(StrictMath.min(t.aX, t.bX), t.cX);
            this.minY = StrictMath.min(StrictMath.min(t.aY, t.bY), t.cY);
            this.maxX = StrictMath.max(StrictMath.max(t.aX, t.bX), t.cX);
            this.maxY = StrictMath.max(StrictMath.max(t.aY, t.bY), t.cY);
            this.triangle = t;
            this.left = null;
            this.right = null;
            Encoder encoder = shapeDocValues.getEncoder();
            double ax = encoder.decodeX(t.aX);
            double ay = encoder.decodeY(t.aY);
            if (t.type == ShapeField.DecodedTriangle.TYPE.POINT) {
                this.midX = ax;
                this.midY = ay;
                this.signedArea = 0.0;
                this.length = 0.0;
            } else if (t.type == ShapeField.DecodedTriangle.TYPE.LINE || t.type == ShapeField.DecodedTriangle.TYPE.TRIANGLE) {
                double bx = encoder.decodeX(t.bX);
                double by = encoder.decodeY(t.bY);
                if (t.type == ShapeField.DecodedTriangle.TYPE.LINE) {
                    this.length = Math.hypot(ax - bx, ay - by);
                    this.midX = 0.5 * (ax + bx) * this.length;
                    this.midY = 0.5 * (ay + by) * this.length;
                    this.signedArea = 0.0;
                } else {
                    double cx = encoder.decodeX(t.cX);
                    double cy = encoder.decodeY(t.cY);
                    this.signedArea = Math.abs(0.5 * ((bx - ax) * (cy - ay) - (cx - ax) * (by - ay)));
                    this.midX = (ax + bx + cx) / 3.0 * this.signedArea;
                    this.midY = (ay + by + cy) / 3.0 * this.signedArea;
                    this.length = 0.0;
                }
            } else {
                throw new IllegalArgumentException("invalid type [" + String.valueOf((Object)t.type) + "] found");
            }
        }
    }

    private final class Writer {
        private final ByteBuffersDataOutput output = new ByteBuffersDataOutput();
        private BytesRef bytesRef;

        Writer(List<TreeNode> dfsSerialized) throws IOException {
            this.writeTree(dfsSerialized);
            this.bytesRef = new BytesRef(this.output.toArrayCopy(), 0, Math.toIntExact(this.output.size()));
        }

        BytesRef getBytesRef() {
            return this.bytesRef;
        }

        private void writeTree(List<TreeNode> dfsSerialized) throws IOException {
            assert (this.output != null) : "passed null datastream to ShapeDocValuesField tessellation tree";
            this.output.writeByte((byte)0);
            this.output.writeVInt(dfsSerialized.size());
            TreeNode root2 = dfsSerialized.remove(0);
            Encoder encoder = ShapeDocValues.this.getEncoder();
            this.output.writeVLong((long)root2.minX - Integer.MIN_VALUE);
            this.output.writeVLong((long)root2.maxX - Integer.MIN_VALUE);
            this.output.writeVLong((long)root2.minY - Integer.MIN_VALUE);
            this.output.writeVLong((long)root2.maxY - Integer.MIN_VALUE);
            this.output.writeVLong((long)encoder.encodeX(root2.midX) - Integer.MIN_VALUE);
            this.output.writeVLong((long)encoder.encodeY(root2.midY) - Integer.MIN_VALUE);
            this.output.writeVInt(root2.highestType.ordinal());
            this.writeHeader(root2);
            this.writeComponent(root2, root2.maxX, root2.maxY);
            for (TreeNode t : dfsSerialized) {
                this.writeNode(t);
            }
        }

        private void writeNode(TreeNode node) throws IOException {
            this.output.writeVInt(node.byteSize);
            this.writeBounds(node);
            this.writeHeader(node);
            this.writeComponent(node, node.parent.maxX, node.parent.maxY);
        }

        private void writeComponent(TreeNode node, int pMaxX, int pMaxY) throws IOException {
            ShapeField.DecodedTriangle t = node.triangle;
            this.output.writeVLong((long)pMaxX - (long)t.aX);
            this.output.writeVLong((long)pMaxY - (long)t.aY);
            if (t.type == ShapeField.DecodedTriangle.TYPE.LINE || t.type == ShapeField.DecodedTriangle.TYPE.TRIANGLE) {
                this.output.writeVLong((long)pMaxX - (long)t.bX);
                this.output.writeVLong((long)pMaxY - (long)t.bY);
            }
            if (t.type == ShapeField.DecodedTriangle.TYPE.TRIANGLE) {
                this.output.writeVLong((long)pMaxX - (long)t.cX);
                this.output.writeVLong((long)pMaxY - (long)t.cY);
            }
        }

        private void writeHeader(TreeNode node) throws IOException {
            int header = 0;
            if (node.right != null) {
                header |= 1;
            }
            if (node.left != null) {
                header |= 2;
            }
            if (node.triangle.type == ShapeField.DecodedTriangle.TYPE.POINT) {
                header |= 4;
            } else if (node.triangle.type == ShapeField.DecodedTriangle.TYPE.LINE) {
                header |= 8;
            }
            if (node.triangle.ab) {
                header |= 0x10;
            }
            if (node.triangle.bc) {
                header |= 0x20;
            }
            if (node.triangle.ca) {
                header |= 0x40;
            }
            this.output.writeVInt(header);
        }

        private void writeBounds(TreeNode node) throws IOException {
            this.output.writeVLong((long)node.parent.maxX - (long)node.minX);
            this.output.writeVLong((long)node.parent.maxY - (long)node.minY);
            this.output.writeVLong((long)node.parent.maxX - (long)node.maxX);
            this.output.writeVLong((long)node.parent.maxY - (long)node.maxY);
        }
    }

    private final class Reader
    extends DataInput {
        private final ByteArrayDataInput data;
        private final BBox bbox;

        Reader(BytesRef binaryValue) {
            this.data = new ByteArrayDataInput(binaryValue.bytes, binaryValue.offset, binaryValue.length);
            this.bbox = new BBox(this, Integer.MAX_VALUE, -2147483647, Integer.MAX_VALUE, -2147483647);
        }

        @Override
        public Reader clone() {
            return new Reader(ShapeDocValues.this.data);
        }

        protected void rewind() {
            this.data.rewind();
        }

        private SpatialQuery.EncodedRectangle readBBox() {
            return this.bbox.reset(Math.toIntExact(this.data.readVLong() + Integer.MIN_VALUE), Math.toIntExact(this.data.readVLong() + Integer.MIN_VALUE), Math.toIntExact(this.data.readVLong() + Integer.MIN_VALUE), Math.toIntExact(this.data.readVLong() + Integer.MIN_VALUE));
        }

        private SpatialQuery.EncodedRectangle resetBBox(int minX, int maxX, int minY, int maxY) {
            return this.bbox.reset(minX, maxX, minY, maxY);
        }

        @Override
        public byte readByte() throws IOException {
            return this.data.readByte();
        }

        @Override
        public void readBytes(byte[] b, int offset, int len) throws IOException {
            this.data.readBytes(b, offset, len);
        }

        @Override
        public void skipBytes(long numBytes) throws IOException {
            this.data.skipBytes(numBytes);
        }

        private final class BBox
        extends SpatialQuery.EncodedRectangle {
            BBox(Reader reader, int minX, int maxX, int minY, int maxY) {
                super(minX, maxX, minY, maxY, false);
            }

            BBox reset(int minX, int maxX, int minY, int maxY) {
                this.minX = minX;
                this.maxX = maxX;
                this.minY = minY;
                this.maxY = maxY;
                this.wrapsCoordinateSystem = false;
                return this;
            }
        }

        private final class Header {
            private Header(Reader reader) {
            }

            private static ShapeField.DecodedTriangle.TYPE readType(int bits) {
                if ((bits & 4) == 4) {
                    return ShapeField.DecodedTriangle.TYPE.POINT;
                }
                if ((bits & 8) == 8) {
                    return ShapeField.DecodedTriangle.TYPE.LINE;
                }
                assert ((bits & 0xC) == 0) : "invalid component type in ShapeDocValuesField";
                return ShapeField.DecodedTriangle.TYPE.TRIANGLE;
            }

            private static boolean readHasLeftSubtree(int bits) {
                return (bits & 2) == 2;
            }

            private static boolean readHasRightSubtree(int bits) {
                return (bits & 1) == 1;
            }
        }
    }

    protected static interface Encoder {
        public int encodeX(double var1);

        public int encodeY(double var1);

        public double decodeX(int var1);

        public double decodeY(int var1);
    }
}

