/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocScoreEncoder;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MaxScoreAccumulator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.LongHeap;

public class TopScoreDocCollector
extends TopDocsCollector<ScoreDoc> {
    private final ScoreDoc after;
    private final LongHeap heap;
    final int totalHitsThreshold;
    final MaxScoreAccumulator minScoreAcc;

    TopScoreDocCollector(int numHits, ScoreDoc after, int totalHitsThreshold, MaxScoreAccumulator minScoreAcc) {
        super(null);
        this.heap = new LongHeap(numHits, DocScoreEncoder.LEAST_COMPETITIVE_CODE);
        this.after = after;
        this.totalHitsThreshold = totalHitsThreshold;
        this.minScoreAcc = minScoreAcc;
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        return results == null ? new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), new ScoreDoc[0]) : new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), results);
    }

    @Override
    public ScoreMode scoreMode() {
        return this.totalHitsThreshold == Integer.MAX_VALUE ? ScoreMode.COMPLETE : ScoreMode.TOP_SCORES;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context2) throws IOException {
        int afterDoc;
        float afterScore;
        final int docBase = context2.docBase;
        final ScoreDoc after = this.after;
        if (after == null) {
            afterScore = Float.POSITIVE_INFINITY;
            afterDoc = Integer.MAX_VALUE;
        } else {
            afterScore = after.score;
            afterDoc = after.doc - context2.docBase;
        }
        return new LeafCollector(){
            private Scorable scorer;
            private long topCode;
            private float topScore;
            private float minCompetitiveScore;
            {
                this.topCode = TopScoreDocCollector.this.heap.top();
                this.topScore = DocScoreEncoder.toScore(this.topCode);
            }

            @Override
            public void setScorer(Scorable scorer) throws IOException {
                this.scorer = scorer;
                if (TopScoreDocCollector.this.minScoreAcc == null) {
                    this.updateMinCompetitiveScore(scorer);
                } else {
                    this.updateGlobalMinCompetitiveScore(scorer);
                }
            }

            @Override
            public void collect(int doc) throws IOException {
                float score = this.scorer.score();
                int hitCountSoFar = ++TopScoreDocCollector.this.totalHits;
                if (TopScoreDocCollector.this.minScoreAcc != null && ((long)hitCountSoFar & TopScoreDocCollector.this.minScoreAcc.modInterval) == 0L) {
                    this.updateGlobalMinCompetitiveScore(this.scorer);
                }
                if (after != null && (score > afterScore || score == afterScore && doc <= afterDoc)) {
                    if (TopScoreDocCollector.this.totalHitsRelation == TotalHits.Relation.EQUAL_TO) {
                        this.updateMinCompetitiveScore(this.scorer);
                    }
                    return;
                }
                if (score <= this.topScore) {
                    if (hitCountSoFar == TopScoreDocCollector.this.totalHitsThreshold + 1) {
                        this.updateMinCompetitiveScore(this.scorer);
                    }
                } else {
                    this.collectCompetitiveHit(doc, score);
                }
            }

            private void collectCompetitiveHit(int doc, float score) throws IOException {
                long code = DocScoreEncoder.encode(doc + docBase, score);
                this.topCode = TopScoreDocCollector.this.heap.updateTop(code);
                this.topScore = DocScoreEncoder.toScore(this.topCode);
                this.updateMinCompetitiveScore(this.scorer);
            }

            private void updateGlobalMinCompetitiveScore(Scorable scorer) throws IOException {
                assert (TopScoreDocCollector.this.minScoreAcc != null);
                long maxMinScore = TopScoreDocCollector.this.minScoreAcc.getRaw();
                if (maxMinScore != Long.MIN_VALUE) {
                    float score = DocScoreEncoder.toScore(maxMinScore);
                    float f = score = docBase >= DocScoreEncoder.docId(maxMinScore) ? Math.nextUp(score) : score;
                    if (score > this.minCompetitiveScore) {
                        scorer.setMinCompetitiveScore(score);
                        this.minCompetitiveScore = score;
                        TopScoreDocCollector.this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                    }
                }
            }

            private void updateMinCompetitiveScore(Scorable scorer) throws IOException {
                float localMinScore;
                if (TopScoreDocCollector.this.totalHits > TopScoreDocCollector.this.totalHitsThreshold && (localMinScore = Math.nextUp(this.topScore)) > this.minCompetitiveScore) {
                    scorer.setMinCompetitiveScore(localMinScore);
                    TopScoreDocCollector.this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                    this.minCompetitiveScore = localMinScore;
                    if (TopScoreDocCollector.this.minScoreAcc != null) {
                        TopScoreDocCollector.this.minScoreAcc.accumulate(this.topCode);
                    }
                }
            }
        };
    }

    @Override
    protected int topDocsSize() {
        int cnt = 0;
        for (int i = 1; i <= this.heap.size(); ++i) {
            if (this.heap.get(i) == DocScoreEncoder.LEAST_COMPETITIVE_CODE) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    protected void populateResults(ScoreDoc[] results, int howMany) {
        for (int i = howMany - 1; i >= 0; --i) {
            long encode = this.heap.pop();
            results[i] = new ScoreDoc(DocScoreEncoder.docId(encode), DocScoreEncoder.toScore(encode));
        }
    }

    @Override
    protected void pruneLeastCompetitiveHitsTo(int keep) {
        for (int i = this.heap.size() - keep; i > 0; --i) {
            this.heap.pop();
        }
    }
}

