/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue;

import java.text.NumberFormat;

public class QueueSize {
    private final int objectCount;
    private final long totalSizeBytes;
    private final int hashCode;

    public QueueSize(int numberObjects, long totalSizeBytes) {
        if (numberObjects < 0 || totalSizeBytes < 0L) {
            throw new IllegalArgumentException();
        }
        this.objectCount = numberObjects;
        this.totalSizeBytes = totalSizeBytes;
        this.hashCode = (int)((long)(41 + 47 * this.objectCount) + 51L * totalSizeBytes);
    }

    public int getObjectCount() {
        return this.objectCount;
    }

    public long getByteCount() {
        return this.totalSizeBytes;
    }

    public QueueSize add(QueueSize other) {
        if (other == null) {
            return new QueueSize(this.objectCount, this.totalSizeBytes);
        }
        return new QueueSize(this.objectCount + other.getObjectCount(), this.totalSizeBytes + other.getByteCount());
    }

    public QueueSize add(int count, long bytes) {
        return new QueueSize(this.objectCount + count, this.totalSizeBytes + bytes);
    }

    public String toString() {
        return "QueueSize[FlowFiles=" + this.objectCount + ", ContentSize=" + NumberFormat.getNumberInstance().format(this.totalSizeBytes) + " Bytes]";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueSize)) {
            return false;
        }
        QueueSize other = (QueueSize)obj;
        return this.getObjectCount() == other.getObjectCount() && this.getByteCount() == other.getByteCount();
    }
}

