/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.bootstrap.process.RuntimeValidator;
import org.apache.nifi.bootstrap.process.RuntimeValidatorResult;

public abstract class AbstractFileBasedRuntimeValidator
implements RuntimeValidator {
    private final File configurationFile;

    AbstractFileBasedRuntimeValidator(File configurationFile) {
        this.configurationFile = configurationFile;
    }

    @Override
    public List<RuntimeValidatorResult> validate() {
        ArrayList<RuntimeValidatorResult> results = new ArrayList<RuntimeValidatorResult>();
        if (!this.canReadConfigurationFile(results)) {
            return results;
        }
        try {
            Pattern pattern = this.getPattern();
            Matcher matcher = pattern.matcher(this.getContents());
            this.performChecks(matcher, results);
        }
        catch (IOException e) {
            RuntimeValidatorResult result = this.getResultBuilder(RuntimeValidatorResult.Outcome.FAILED).explanation(String.format("Configuration file [%s] cannot be read", this.getConfigurationFile().getAbsolutePath())).build();
            results.add(result);
        }
        this.processResults(results);
        return results;
    }

    protected RuntimeValidatorResult.Builder getResultBuilder(RuntimeValidatorResult.Outcome outcome) {
        return new RuntimeValidatorResult.Builder().subject(this.getClass().getSimpleName()).outcome(outcome);
    }

    protected File getConfigurationFile() {
        return this.configurationFile;
    }

    protected String getContents() throws IOException {
        try (Scanner scanner = new Scanner(this.configurationFile);){
            StringBuilder builder = new StringBuilder();
            while (scanner.hasNextLine()) {
                builder.append(scanner.nextLine());
                builder.append(System.lineSeparator());
            }
            String string = builder.toString();
            return string;
        }
    }

    protected abstract Pattern getPattern();

    protected abstract void performChecks(Matcher var1, List<RuntimeValidatorResult> var2);

    private boolean canReadConfigurationFile(List<RuntimeValidatorResult> results) {
        File configurationFile = this.getConfigurationFile();
        if (configurationFile == null) {
            RuntimeValidatorResult result = this.getResultBuilder(RuntimeValidatorResult.Outcome.SKIPPED).explanation("Configuration file not found").build();
            results.add(result);
            return false;
        }
        if (!configurationFile.canRead()) {
            RuntimeValidatorResult result = this.getResultBuilder(RuntimeValidatorResult.Outcome.SKIPPED).explanation(String.format("Configuration file [%s] cannot be read", configurationFile.getAbsolutePath())).build();
            results.add(result);
            return false;
        }
        return true;
    }

    private void processResults(List<RuntimeValidatorResult> results) {
        if (results.isEmpty()) {
            RuntimeValidatorResult result = this.getResultBuilder(RuntimeValidatorResult.Outcome.SUCCESSFUL).build();
            results.add(result);
        }
    }
}

