/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import org.apache.sis.index.tree.PointTreeNode;

final class QuadTreeNode
extends PointTreeNode {
    static final int NE = 0;
    static final int NW = 1;
    static final int SE = 2;
    static final int SW = 3;
    private Object nw;
    private Object ne;
    private Object se;
    private Object sw;

    QuadTreeNode() {
    }

    @Override
    final PointTreeNode newInstance() {
        return new QuadTreeNode();
    }

    @Override
    final void clear() {
        this.sw = null;
        this.se = null;
        this.ne = null;
        this.nw = null;
    }

    @Override
    final Object getChild(int quadrant) {
        Object child;
        switch (quadrant) {
            case 1: {
                child = this.nw;
                break;
            }
            case 0: {
                child = this.ne;
                break;
            }
            case 3: {
                child = this.sw;
                break;
            }
            case 2: {
                child = this.se;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(quadrant);
            }
        }
        return child;
    }

    @Override
    final void setChild(int quadrant, Object child) {
        switch (quadrant) {
            case 1: {
                this.nw = child;
                break;
            }
            case 0: {
                this.ne = child;
                break;
            }
            case 3: {
                this.sw = child;
                break;
            }
            case 2: {
                this.se = child;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(quadrant);
            }
        }
    }

    @Override
    protected Object clone() {
        QuadTreeNode c = (QuadTreeNode)super.clone();
        for (int i = 0; i < 4; ++i) {
            Object value = c.getChild(i);
            if (!(value instanceof PointTreeNode)) continue;
            c.setChild(i, ((PointTreeNode)value).clone());
        }
        return c;
    }
}

