/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.lang.reflect.Type;
import java.util.Map;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.UnknownNameException;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.DefaultScopedName;
import org.apache.sis.util.iso.DefaultTypeName;
import org.apache.sis.util.iso.TypeNames;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;
import org.opengis.util.TypeName;

public final class Names
extends Static {
    private static final MemberName[] SEQUENCE_NUMBERS = new MemberName[16];

    private Names() {
    }

    private static NameSpace createNameSpace(NameFactory factory, CharSequence namespace, String separator) {
        if (namespace == null || namespace.length() == 0) {
            return null;
        }
        return factory.createNameSpace((GenericName)factory.createLocalName(null, namespace), separator == null ? null : Map.of("separator.head", separator));
    }

    public static GenericName parseGenericName(CharSequence namespace, String separator, CharSequence scopedName) {
        ArgumentChecks.ensureNonNull((String)"localPart", (Object)scopedName);
        DefaultNameFactory factory = DefaultNameFactory.provider();
        return factory.parseGenericName(Names.createNameSpace(factory, namespace, separator), scopedName);
    }

    public static GenericName createGenericName(CharSequence namespace, String separator, CharSequence ... parsedNames) {
        ArgumentChecks.ensureNonNull((String)"parsedNames", (Object)parsedNames);
        DefaultNameFactory factory = DefaultNameFactory.provider();
        return factory.createGenericName(Names.createNameSpace(factory, namespace, separator), parsedNames);
    }

    public static ScopedName createScopedName(GenericName scope, String separator, CharSequence name) {
        return new DefaultScopedName(scope, separator, name);
    }

    public static LocalName createLocalName(CharSequence namespace, String separator, CharSequence localPart) {
        ArgumentChecks.ensureNonNull((String)"localPart", (Object)localPart);
        DefaultNameFactory factory = DefaultNameFactory.provider();
        return factory.createLocalName(Names.createNameSpace(factory, namespace, separator), localPart);
    }

    public static TypeName createTypeName(CharSequence namespace, String separator, CharSequence localPart) {
        ArgumentChecks.ensureNonNull((String)"localPart", (Object)localPart);
        DefaultNameFactory factory = DefaultNameFactory.provider();
        return factory.createTypeName(Names.createNameSpace(factory, namespace, separator), localPart);
    }

    public static TypeName createTypeName(Class<?> valueClass) {
        ArgumentChecks.ensureNonNull((String)"valueClass", valueClass);
        DefaultNameFactory factory = DefaultNameFactory.provider();
        return factory.toTypeName(valueClass);
    }

    static MemberName createMemberName(GenericName namespace, CharSequence localPart, Class<?> valueClass) {
        DefaultNameFactory factory = DefaultNameFactory.provider();
        return factory.createMemberName(factory.createNameSpace(namespace, null), localPart, factory.toTypeName(valueClass));
    }

    public static MemberName createMemberName(CharSequence namespace, String separator, CharSequence localPart, Class<?> valueClass) {
        ArgumentChecks.ensureNonNull((String)"localPart", (Object)localPart);
        ArgumentChecks.ensureNonNull((String)"valueClass", valueClass);
        DefaultNameFactory factory = DefaultNameFactory.provider();
        return factory.createMemberName(Names.createNameSpace(factory, namespace, separator), localPart, factory.toTypeName(valueClass));
    }

    public static MemberName createMemberName(CharSequence namespace, String separator, CharSequence localPart, TypeName attributeType) {
        ArgumentChecks.ensureNonNull((String)"localPart", (Object)localPart);
        ArgumentChecks.ensureNonNull((String)"attributeType", (Object)attributeType);
        DefaultNameFactory factory = DefaultNameFactory.provider();
        return factory.createMemberName(Names.createNameSpace(factory, namespace, separator), localPart, attributeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static MemberName createMemberName(CharSequence namespace, String separator, int localPart) {
        MemberName[] memberNameArray;
        if (":".equals(separator)) {
            separator = null;
        }
        boolean cached = namespace == null && separator == null && localPart >= 0 && localPart < SEQUENCE_NUMBERS.length;
        MemberName name = null;
        if (cached) {
            memberNameArray = SEQUENCE_NUMBERS;
            // MONITORENTER : SEQUENCE_NUMBERS
            name = SEQUENCE_NUMBERS[localPart];
            // MONITOREXIT : memberNameArray
        }
        if (name != null) return name;
        name = Names.createMemberName(namespace, separator, (CharSequence)Integer.toString(localPart), Integer.class);
        if (!cached) return name;
        memberNameArray = SEQUENCE_NUMBERS;
        // MONITORENTER : SEQUENCE_NUMBERS
        Names.SEQUENCE_NUMBERS[localPart] = name;
        // MONITOREXIT : memberNameArray
        return name;
    }

    public static Class<?> toClass(TypeName type) throws UnknownNameException {
        ClassNotFoundException cause;
        Type t;
        if (type == null) {
            return null;
        }
        if (type instanceof DefaultTypeName && (t = (Type)((DefaultTypeName)type).toJavaType().orElse(null)) instanceof Class) {
            return (Class)t;
        }
        try {
            Class<?> c = TypeNames.toClass(TypeNames.namespace(type.scope()), type.toString());
            if (c != Void.TYPE) {
                return c;
            }
            cause = null;
        }
        catch (ClassNotFoundException e) {
            cause = e;
        }
        throw new UnknownNameException(Errors.format((short)182, (Object)type.toFullyQualifiedName()), (Throwable)cause);
    }

    public static String toExpandedString(GenericName name) {
        if (name == null) {
            return null;
        }
        String localPart = name.toString();
        NameSpace scope = name.scope();
        if (scope == null || scope.isGlobal()) {
            return localPart;
        }
        String ns = scope.name().toString();
        return new StringBuilder(ns.length() + localPart.length() + 2).append('{').append(ns).append('}').append(localPart).toString();
    }
}

