/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.filter.Expression;
import org.apache.sis.style.se1.Graphic;
import org.apache.sis.style.se1.GraphicalElement;
import org.apache.sis.style.se1.StyleElement;
import org.apache.sis.style.se1.StyleFactory;

@XmlType(name="GraphicStrokeType", propOrder={"graphic", "initialGap", "gap"})
@XmlRootElement(name="GraphicStroke")
public class GraphicStroke<R>
extends StyleElement<R>
implements GraphicalElement<R> {
    protected Graphic<R> graphic;
    @XmlElement(name="InitialGap")
    protected Expression<R, ? extends Number> initialGap;
    @XmlElement(name="Gap")
    protected Expression<R, ? extends Number> gap;

    private GraphicStroke() {
    }

    public GraphicStroke(StyleFactory<R> factory) {
        super(factory);
    }

    public GraphicStroke(GraphicStroke<R> source) {
        super(source);
        this.graphic = source.graphic;
        this.initialGap = source.initialGap;
        this.gap = source.gap;
    }

    @Override
    @XmlElement(name="Graphic", required=true)
    public final Graphic<R> getGraphic() {
        if (this.graphic == null) {
            this.graphic = this.factory.createGraphic();
        }
        return this.graphic;
    }

    @Override
    public final void setGraphic(Graphic<R> value) {
        this.graphic = value;
    }

    public Expression<R, ? extends Number> getInitialGap() {
        return this.defaultToZero(this.initialGap);
    }

    public void setInitialGap(Expression<R, ? extends Number> value) {
        this.initialGap = value;
    }

    public Expression<R, ? extends Number> getGap() {
        return this.defaultToZero(this.gap);
    }

    public void setGap(Expression<R, ? extends Number> value) {
        this.gap = value;
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.graphic, this.initialGap, this.gap};
    }

    @Override
    public GraphicStroke<R> clone() {
        GraphicStroke clone = (GraphicStroke)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        if (this.graphic != null) {
            this.graphic = this.graphic.clone();
        }
    }
}

