/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Optional;
import org.apache.sis.filter.Expression;
import org.apache.sis.style.se1.ChannelSelection;
import org.apache.sis.style.se1.ColorMap;
import org.apache.sis.style.se1.ContrastEnhancement;
import org.apache.sis.style.se1.OverlapBehavior;
import org.apache.sis.style.se1.ShadedRelief;
import org.apache.sis.style.se1.StyleFactory;
import org.apache.sis.style.se1.Symbolizer;
import org.apache.sis.style.se1.Translucent;

@XmlType(name="RasterSymbolizerType", propOrder={"opacity", "channelSelection", "overlapBehavior", "colorMap", "contrastEnhancement", "shadedRelief", "imageOutline"})
@XmlRootElement(name="RasterSymbolizer")
public class RasterSymbolizer<R>
extends Symbolizer<R>
implements Translucent<R> {
    @XmlElement(name="Opacity")
    protected Expression<R, ? extends Number> opacity;
    @XmlElement(name="ChannelSelection")
    protected ChannelSelection<R> channelSelection;
    @XmlElement(name="OverlapBehavior")
    protected OverlapBehavior overlapBehavior;
    @XmlElement(name="ColorMap")
    protected ColorMap<R> colorMap;
    @XmlElement(name="ContrastEnhancement")
    protected ContrastEnhancement<R> contrastEnhancement;
    @XmlElement(name="ShadedRelief")
    protected ShadedRelief<R> shadedRelief;
    @XmlElement(name="ImageOutline")
    protected Symbolizer<R> imageOutline;

    private RasterSymbolizer() {
    }

    public RasterSymbolizer(StyleFactory<R> factory) {
        super(factory);
    }

    public RasterSymbolizer(RasterSymbolizer<R> source) {
        super(source);
        this.opacity = source.opacity;
        this.channelSelection = source.channelSelection;
        this.overlapBehavior = source.overlapBehavior;
        this.colorMap = source.colorMap;
        this.contrastEnhancement = source.contrastEnhancement;
        this.shadedRelief = source.shadedRelief;
        this.imageOutline = source.imageOutline;
    }

    @Override
    public Expression<R, ? extends Number> getOpacity() {
        return this.defaultToOne(this.opacity);
    }

    @Override
    public void setOpacity(Expression<R, ? extends Number> value) {
        this.opacity = value;
    }

    public Optional<ChannelSelection<R>> getChannelSelection() {
        return Optional.ofNullable(this.channelSelection);
    }

    public void setChannelSelection(ChannelSelection<R> value) {
        this.channelSelection = value;
    }

    public OverlapBehavior getOverlapBehavior() {
        OverlapBehavior value = this.overlapBehavior;
        return value != null ? value : OverlapBehavior.LATEST_ON_TOP;
    }

    public void setOverlapBehavior(OverlapBehavior value) {
        this.overlapBehavior = value;
    }

    public Optional<ColorMap<R>> getColorMap() {
        return Optional.ofNullable(this.colorMap);
    }

    public void setColorMap(ColorMap<R> value) {
        this.colorMap = value;
    }

    public Optional<ContrastEnhancement<R>> getContrastEnhancement() {
        return Optional.ofNullable(this.contrastEnhancement);
    }

    public void setContrastEnhancement(ContrastEnhancement<R> value) {
        this.contrastEnhancement = value;
    }

    public Optional<ShadedRelief<R>> getShadedRelief() {
        return Optional.ofNullable(this.shadedRelief);
    }

    public void setShadedRelief(ShadedRelief<R> value) {
        this.shadedRelief = value;
    }

    public Optional<Symbolizer<R>> getImageOutline() {
        return Optional.ofNullable(this.imageOutline);
    }

    public void setImageOutline(Symbolizer<R> value) {
        this.imageOutline = value;
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.opacity, this.channelSelection, this.overlapBehavior, this.colorMap, this.contrastEnhancement, this.shadedRelief, this.imageOutline};
    }

    @Override
    public RasterSymbolizer<R> clone() {
        RasterSymbolizer clone = (RasterSymbolizer)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        if (this.channelSelection != null) {
            this.channelSelection = this.channelSelection.clone();
        }
        if (this.colorMap != null) {
            this.colorMap = this.colorMap.clone();
        }
        if (this.contrastEnhancement != null) {
            this.contrastEnhancement = this.contrastEnhancement.clone();
        }
        if (this.shadedRelief != null) {
            this.shadedRelief = this.shadedRelief.clone();
        }
        if (this.imageOutline != null) {
            this.imageOutline = this.imageOutline.clone();
        }
    }
}

