/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers.slinginitialcontent;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.BundleSlingInitialContentExtractContext;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageUtils;
import org.apache.sling.jcr.contentloader.PathEntry;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssemblerProvider {
    private static final Logger logger = LoggerFactory.getLogger(AssemblerProvider.class);
    private final Map<PackageType, VaultPackageAssembler> packageAssemblers = new EnumMap<PackageType, VaultPackageAssembler>(PackageType.class);

    AssemblerProvider() {
    }

    @NotNull
    public VaultPackageAssembler initPackageAssemblerForPath(@NotNull BundleSlingInitialContentExtractContext context, @NotNull String repositoryPath, @NotNull PathEntry pathEntry) throws ConverterException {
        ArtifactId bundleArtifactId = context.getBundleArtifactId();
        PackageType packageType = VaultPackageUtils.detectPackageType(repositoryPath);
        VaultPackageAssembler assembler = this.lazyConstruct(context, repositoryPath, bundleArtifactId, packageType);
        this.addPathFilterSetToAssemblerFilter(pathEntry, assembler);
        return assembler;
    }

    @NotNull
    public Set<Map.Entry<PackageType, VaultPackageAssembler>> getPackageAssemblerEntrySet() {
        return this.packageAssemblers.entrySet();
    }

    @NotNull
    private VaultPackageAssembler lazyConstruct(@NotNull BundleSlingInitialContentExtractContext context, @NotNull String repositoryPath, @NotNull ArtifactId bundleArtifactId, @NotNull PackageType packageType) throws ConverterException {
        VaultPackageAssembler assembler = this.packageAssemblers.get(packageType);
        if (assembler == null) {
            String packageNameSuffix;
            switch (packageType) {
                case APPLICATION: {
                    packageNameSuffix = "-apps";
                    break;
                }
                case CONTENT: {
                    packageNameSuffix = "-content";
                    break;
                }
                default: {
                    throw new ConverterException("Unexpected package type " + packageType + " detected for path " + repositoryPath);
                }
            }
            PackageId packageId = new PackageId(bundleArtifactId.getGroupId(), bundleArtifactId.getArtifactId() + packageNameSuffix, bundleArtifactId.getVersion());
            assembler = VaultPackageAssembler.create(context.getConverter().getTempDirectory(), packageId, "Generated out of Sling Initial Content from bundle " + bundleArtifactId + " by cp2fm");
            this.packageAssemblers.put(packageType, assembler);
            logger.info("Created package {} out of Sling-Initial-Content from '{}'", (Object)packageId, (Object)bundleArtifactId);
        }
        return assembler;
    }

    private void addPathFilterSetToAssemblerFilter(@NotNull PathEntry pathEntry, @NotNull VaultPackageAssembler assembler) {
        ImportMode importMode = pathEntry.isOverwrite() ? ImportMode.UPDATE : ImportMode.MERGE;
        DefaultWorkspaceFilter filter = assembler.getFilter();
        if (filter.getFilterSets().stream().noneMatch(set -> set.getRoot().equals(pathEntry.getTarget() != null ? pathEntry.getTarget() : "/") && set.getImportMode() == importMode)) {
            PathFilterSet pathFilterSet = new PathFilterSet(pathEntry.getTarget() != null ? pathEntry.getTarget() : "/");
            pathFilterSet.setImportMode(importMode);
            filter.add(pathFilterSet);
        }
    }

    public void clear() {
        this.packageAssemblers.clear();
    }
}

