/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.datatable.button;

import com.github.openjson.JSONObject;
import com.googlecode.wicket.kendo.ui.datatable.button.AbstractButton;
import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;

public class ToolbarButton
extends AbstractButton {
    private static final long serialVersionUID = 1L;

    public ToolbarButton(String name) {
        super(name);
    }

    public ToolbarButton(String name, IModel<String> text) {
        super(name, text);
    }

    public ToolbarButton(String name, String property) {
        super(name, property);
    }

    public ToolbarButton(String name, IModel<String> text, String property) {
        super(name, text, property);
    }

    @Override
    public boolean isBuiltIn() {
        switch (this.getName()) {
            case "edit": 
            case "save": 
            case "create": 
            case "cancel": 
            case "destroy": {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public JSONObject toJSONObject() {
        JSONObject object = new JSONObject();
        object.put("name", (Object)(this.isEnabled() ? this.getName() : "disabled"));
        object.put("text", this.getTextModel().getObject());
        if (!Strings.isEmpty((String)this.getCSSClass())) {
            object.put("className", (Object)this.getCSSClass());
        }
        if (!Strings.isEmpty((String)this.getIconClass())) {
            object.put("iconClass", (Object)this.getIconClass());
        }
        return object;
    }

    public void onClick(AjaxRequestTarget target, List<String> values) {
    }
}

