/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.instrumentation.jmx;

import javax.management.ObjectName;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.instrumentation.AbstractQueryCacheInstrument;
import org.apache.openjpa.instrumentation.jmx.JMXInstrument;
import org.apache.openjpa.instrumentation.jmx.JMXProvider;
import org.apache.openjpa.instrumentation.jmx.QueryCacheJMXInstrumentMBean;
import org.apache.openjpa.lib.instrumentation.Instrument;
import org.apache.openjpa.lib.instrumentation.InstrumentationLevel;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.UserException;

public class QueryCacheJMXInstrument
extends AbstractQueryCacheInstrument
implements JMXInstrument,
QueryCacheJMXInstrumentMBean {
    private static Localizer _loc = Localizer.forPackage(QueryCacheJMXInstrument.class);
    private static final String MBEAN_TYPE = "QueryCache";
    private ObjectName _objName = null;

    public String getName() {
        return MBEAN_TYPE;
    }

    @Override
    public InstrumentationLevel getLevel() {
        return InstrumentationLevel.FACTORY;
    }

    public void initialize() {
        OpenJPAConfiguration conf = (OpenJPAConfiguration)this.getProvider().getConfiguration();
        DataCacheManager dcm = conf.getDataCacheManagerInstance();
        QueryCache qc = dcm.getSystemQueryCache();
        if (qc == null) {
            throw new UserException(_loc.get("query-cache-not-found"));
        }
        this.setQueryCache(qc);
        this.setConfigId(conf.getId());
        this.setContextRef(Integer.toString(System.identityHashCode(this.getContext())));
    }

    @Override
    public ObjectName getObjectName() {
        if (this._objName != null) {
            return this._objName;
        }
        try {
            this._objName = JMXProvider.createObjectName(this, null);
            return this._objName;
        }
        catch (Throwable t) {
            throw new UserException(_loc.get("unable-to-create-object-name", (Object)this.getName()), t);
        }
    }

    public void start() {
        this.getProvider().startInstrument((Instrument)this);
    }

    public void stop() {
        this.getProvider().stopInstrument((Instrument)this);
    }
}

