/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.repository;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.DeploymentQueryImpl;
import org.flowable.engine.impl.ProcessDefinitionQueryImpl;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.DeploymentMergeStrategy;
import org.flowable.engine.repository.DeploymentQuery;
import org.flowable.engine.repository.ProcessDefinition;

public class MergeByDateDeploymentMergeStrategy
implements DeploymentMergeStrategy {
    @Override
    public void prepareMerge(CommandContext commandContext, String deploymentId, String newTenantId) {
        List processDefinitions = new ProcessDefinitionQueryImpl().deploymentId(deploymentId).list();
        ProcessDefinitionEntityManager processDefinitionEntityManager = CommandContextUtil.getProcessDefinitionEntityManager(commandContext);
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionEntityManager.updateProcessDefinitionVersionForProcessDefinitionId(processDefinition.getId(), 0);
        }
    }

    @Override
    public void finalizeMerge(CommandContext commandContext, String deploymentId, String newTenantId) {
        List processDefinitions = new ProcessDefinitionQueryImpl().deploymentId(deploymentId).list();
        ProcessDefinitionEntityManager processDefinitionEntityManager = CommandContextUtil.getProcessDefinitionEntityManager(commandContext);
        for (ProcessDefinition processDefinition : processDefinitions) {
            ProcessDefinitionQueryImpl processDefinitionQuery = new ProcessDefinitionQueryImpl();
            if (StringUtils.isEmpty((CharSequence)newTenantId)) {
                processDefinitionQuery.processDefinitionWithoutTenantId();
            } else {
                processDefinitionQuery.processDefinitionTenantId(newTenantId);
            }
            List allProcessDefinitionsWithKey = processDefinitionQuery.processDefinitionKey(processDefinition.getKey()).list();
            List<ProcessDefinition> orderedProcessDefinitions = this.sortProcessDefinitionsByDeploymentTime(allProcessDefinitionsWithKey);
            int versionNumber = allProcessDefinitionsWithKey.size();
            for (ProcessDefinition alreadyExistingProcessDefinition : orderedProcessDefinitions) {
                processDefinitionEntityManager.updateProcessDefinitionVersionForProcessDefinitionId(alreadyExistingProcessDefinition.getId(), versionNumber--);
            }
        }
    }

    protected List<ProcessDefinition> sortProcessDefinitionsByDeploymentTime(List<ProcessDefinition> allProcessDefinitionsWithKey) {
        List<String> deploymentIds = this.extractDeploymentIds(allProcessDefinitionsWithKey);
        Map processDefinitionLookupTable = allProcessDefinitionsWithKey.stream().collect(Collectors.toMap(ProcessDefinition::getDeploymentId, Function.identity()));
        return ((DeploymentQuery)((DeploymentQueryImpl)new DeploymentQueryImpl().deploymentIds((List)deploymentIds)).orderByDeploymentTime().desc()).list().stream().map(deployment -> (ProcessDefinition)processDefinitionLookupTable.get(deployment.getId())).collect(Collectors.toList());
    }

    protected List<String> extractDeploymentIds(List<ProcessDefinition> allProcessDefinitionsWithKey) {
        return allProcessDefinitionsWithKey.stream().map(ProcessDefinition::getDeploymentId).collect(Collectors.toList());
    }
}

