/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractResourceAssociator;
import org.apache.syncope.core.logic.api.LogicActions;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.implementation.ImplementationManager;

public abstract class AbstractAnyLogic<TO extends AnyTO, C extends AnyCR, U extends AnyUR>
extends AbstractResourceAssociator<TO> {
    protected static final String REST_CONTEXT = "REST";
    protected final RealmDAO realmDAO;
    protected final AnyTypeDAO anyTypeDAO;
    protected final TemplateUtils templateUtils;
    protected final Map<String, LogicActions> perContextActions = new ConcurrentHashMap<String, LogicActions>();

    public AbstractAnyLogic(RealmDAO realmDAO, AnyTypeDAO anyTypeDAO, TemplateUtils templateUtils) {
        this.realmDAO = realmDAO;
        this.anyTypeDAO = anyTypeDAO;
        this.templateUtils = templateUtils;
    }

    protected List<LogicActions> getActions(Realm realm) {
        ArrayList<LogicActions> result = new ArrayList<LogicActions>();
        realm.getActions().forEach(impl -> {
            try {
                result.add((LogicActions)ImplementationManager.build((Implementation)impl, () -> this.perContextActions.get(impl.getKey()), instance -> this.perContextActions.put(impl.getKey(), (LogicActions)instance)));
            }
            catch (Exception e) {
                LOG.warn("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    protected Pair<C, List<LogicActions>> beforeCreate(C input) {
        Realm realm = this.realmDAO.findByFullPath(input.getRealm());
        if (realm == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            sce.getElements().add(input.getRealm());
            throw sce;
        }
        AnyType anyType = null;
        if (input instanceof UserCR) {
            anyType = this.anyTypeDAO.findUser();
        } else if (input instanceof GroupCR) {
            anyType = this.anyTypeDAO.findGroup();
        } else if (input instanceof AnyObjectCR) {
            anyType = this.anyTypeDAO.find(((AnyObjectCR)input).getType());
        }
        if (anyType == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            throw sce;
        }
        C anyCR = input;
        this.templateUtils.apply(anyCR, realm.getTemplate(anyType));
        List<LogicActions> actions = this.getActions(realm);
        for (LogicActions action : actions) {
            anyCR = action.beforeCreate(anyCR);
        }
        LOG.debug("Input: {}\nOutput: {}\n", input, anyCR);
        return Pair.of(anyCR, actions);
    }

    protected Pair<U, List<LogicActions>> beforeUpdate(U input, String realmPath) {
        Realm realm = this.realmDAO.findByFullPath(realmPath);
        if (realm == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            sce.getElements().add(realmPath);
            throw sce;
        }
        U update = input;
        List<LogicActions> actions = this.getActions(realm);
        for (LogicActions action : actions) {
            update = action.beforeUpdate(update);
        }
        LOG.debug("Input: {}\nOutput: {}\n", input, update);
        return Pair.of(update, actions);
    }

    protected Pair<TO, List<LogicActions>> beforeDelete(TO input) {
        Realm realm = this.realmDAO.findByFullPath(input.getRealm());
        if (realm == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            sce.getElements().add(input.getRealm());
            throw sce;
        }
        TO any = input;
        List<LogicActions> actions = this.getActions(realm);
        for (LogicActions action : actions) {
            any = action.beforeDelete(any);
        }
        LOG.debug("Input: {}\nOutput: {}\n", input, any);
        return Pair.of(any, actions);
    }

    protected ProvisioningResult<TO> afterCreate(TO input, List<PropagationStatus> statuses, List<LogicActions> actions) {
        TO any = input;
        for (LogicActions action : actions) {
            any = action.afterCreate(any, statuses);
        }
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity(any);
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    protected ProvisioningResult<TO> afterUpdate(TO input, List<PropagationStatus> statuses, List<LogicActions> actions) {
        TO any = input;
        for (LogicActions action : actions) {
            any = action.afterUpdate(any, statuses);
        }
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity(any);
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    protected ProvisioningResult<TO> afterDelete(TO input, List<PropagationStatus> statuses, List<LogicActions> actions) {
        TO any = input;
        for (LogicActions action : actions) {
            any = action.afterDelete(any, statuses);
        }
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity(any);
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    public abstract TO read(String var1);

    public abstract Pair<Integer, List<TO>> search(SearchCond var1, int var2, int var3, List<OrderByClause> var4, String var5, boolean var6, boolean var7);

    public abstract ProvisioningResult<TO> update(U var1, boolean var2);

    public abstract ProvisioningResult<TO> delete(String var1, boolean var2);
}

