/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.net.core.BufferManager;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public abstract class AbstractBufferManager
implements BufferManager {
    @Override
    public int forwardFromReadBuffer(ByteBuffer dest) {
        ByteBuffer recvBuffer = this.getRecvBuffer();
        recvBuffer.flip();
        int forwarded = AbstractBufferManager.forwardBuffer(recvBuffer, dest);
        recvBuffer.compact();
        return forwarded;
    }

    @Override
    public int forwardFromReadBuffer(GatheringByteChannel gbc) throws IOException {
        ByteBuffer recvBuffer = this.getRecvBuffer();
        recvBuffer.flip();
        int forwarded = gbc.write(recvBuffer);
        recvBuffer.compact();
        if (forwarded == -1) {
            throw new EOFException();
        }
        return forwarded;
    }

    @Override
    public int forwardToWriteBuffer(ByteBuffer src) {
        ByteBuffer sendBuffer = this.getSendBuffer();
        return AbstractBufferManager.forwardBuffer(src, sendBuffer);
    }

    @Override
    public int forwardToWriteBuffer(ScatteringByteChannel sbc) throws IOException {
        ByteBuffer sendBuffer = this.getSendBuffer();
        int read = sbc.read(sendBuffer);
        if (read == -1) {
            throw new EOFException();
        }
        return read;
    }

    protected abstract ByteBuffer getRecvBuffer();

    protected abstract ByteBuffer getSendBuffer();

    private static int forwardBuffer(ByteBuffer source, ByteBuffer dest) {
        int size = Math.min(dest.remaining(), source.remaining());
        if (size > 0) {
            ByteBuffer tmpBuf = source.duplicate();
            tmpBuf.limit(tmpBuf.position() + size);
            dest.put(tmpBuf);
            source.position(source.position() + size);
        }
        return size;
    }
}

