/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class EncodingUtil {
    public static final String EIGHT_BIT_ENCODING = "ISO-8859-1";
    public static final Charset CHARSET_EIGHT_BIT_ENCODING = StandardCharsets.ISO_8859_1;

    private EncodingUtil() {
    }

    public static InputStream toStream(String content, Charset charset) {
        byte[] bytes = content.getBytes(charset);
        return new ByteArrayInputStream(bytes);
    }

    public static String toString(InputStream is, Charset charset) {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = is.read(buffer)) != -1) {
                data.write(buffer, 0, length);
            }
            return data.toString(charset.name());
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not convert stream to string of charset " + charset, e);
        }
    }

    public static String decodeBase64(String encoded) {
        return new String(Base64.getDecoder().decode(encoded), StandardCharsets.UTF_8);
    }
}

