/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import org.apache.xml.security.utils.ClassLoaderUtils;
import org.apache.xml.security.utils.JDKXPathFactory;
import org.apache.xml.security.utils.XPathAPI;
import org.apache.xml.security.utils.XalanXPathAPI;
import org.apache.xml.security.utils.XalanXPathFactory;

public abstract class XPathFactory {
    private static final boolean xalanInstalled;

    public static XPathFactory newInstance() {
        if (xalanInstalled && XalanXPathAPI.isInstalled()) {
            return new XalanXPathFactory();
        }
        return new JDKXPathFactory();
    }

    public abstract XPathAPI newXPathAPI();

    static {
        boolean installed = false;
        try {
            Class<?> funcTableClass = ClassLoaderUtils.loadClass("org.apache.xpath.compiler.FunctionTable", XPathFactory.class);
            if (funcTableClass != null) {
                installed = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        xalanInstalled = installed;
    }
}

