/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.schema.DefinitionFunction;
import org.ldaptive.schema.Extensions;
import org.ldaptive.schema.SchemaElement;
import org.ldaptive.schema.SchemaUtils;

public abstract class AbstractRegexDefinitionFunction<T extends SchemaElement>
implements DefinitionFunction<T> {
    protected static final String WSP_REGEX = "[ ]*";
    protected static final String ONE_WSP_REGEX = "[ ]+";
    protected static final String NO_WSP_REGEX = "[^ ]+";
    private static final Pattern EXTENSIONS_PATTERN = Pattern.compile("(?:(X-[^ ]+)[ ]*(?:'([^']+)'|\\(([^\\)]+)\\))?)+");

    protected Extensions parseExtensions(String definition) {
        Matcher m = EXTENSIONS_PATTERN.matcher(definition);
        Extensions exts = new Extensions();
        while (m.find()) {
            String name = m.group(1).trim();
            ArrayList<String> values = new ArrayList<String>(1);
            if (m.group(2) != null) {
                values.add(m.group(2).trim());
            } else if (m.group(3) != null) {
                values.addAll(Arrays.asList(SchemaUtils.parseDescriptors(m.group(3).trim())));
            }
            exts.addExtension(name, values);
        }
        return exts;
    }
}

