/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.config.BeanReferenceParser;
import org.springmodules.cache.config.BeanReferenceParserImpl;
import org.springmodules.cache.config.CacheModelParser;
import org.springmodules.cache.config.CacheSetupStrategyPropertySource;
import org.springmodules.cache.config.CachingListenerValidator;
import org.springmodules.cache.config.CachingListenerValidatorImpl;
import org.w3c.dom.Element;

public abstract class AbstractCacheSetupStrategyParser
implements BeanDefinitionParser {
    private BeanReferenceParser beanReferenceParser = new BeanReferenceParserImpl();
    private CacheModelParser cacheModelParser;
    private CachingListenerValidator cachingListenerValidator = new CachingListenerValidatorImpl();

    public final BeanDefinition parse(Element element, ParserContext parserContext) throws NoSuchBeanDefinitionException, IllegalStateException {
        String cacheProviderFacadeId = element.getAttribute("providerId");
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (!registry.containsBeanDefinition(cacheProviderFacadeId)) {
            throw new IllegalStateException("An implementation of CacheProviderFacade should be registered under the name " + StringUtils.quote((String)cacheProviderFacadeId));
        }
        RuntimeBeanReference cacheProviderFacadeReference = new RuntimeBeanReference(cacheProviderFacadeId);
        Object cacheKeyGenerator = this.parseCacheKeyGenerator(element, parserContext);
        List cachingListeners = this.parseCachingListeners(element, parserContext);
        Map cachingModels = this.parseCachingModels(element);
        Map flushingModels = this.parseFlushingModels(element);
        CacheSetupStrategyPropertySource ps = new CacheSetupStrategyPropertySource(cacheKeyGenerator, cacheProviderFacadeReference, cachingListeners, cachingModels, flushingModels);
        this.parseCacheSetupStrategy(element, parserContext, ps);
        return null;
    }

    public final void setCacheModelParser(CacheModelParser newCacheModelParser) {
        this.cacheModelParser = newCacheModelParser;
    }

    protected final BeanReferenceParser getBeanReferenceParser() {
        return this.beanReferenceParser;
    }

    protected abstract String getCacheModelKey();

    protected final CacheModelParser getCacheModelParser() {
        return this.cacheModelParser;
    }

    protected abstract void parseCacheSetupStrategy(Element var1, ParserContext var2, CacheSetupStrategyPropertySource var3);

    protected final void setBeanReferenceParser(BeanReferenceParser newBeanReferenceParser) {
        this.beanReferenceParser = newBeanReferenceParser;
    }

    protected final void setCachingListenerValidator(CachingListenerValidator newCachingListenerValidator) {
        this.cachingListenerValidator = newCachingListenerValidator;
    }

    private Object parseCacheKeyGenerator(Element element, ParserContext parserContext) {
        Object keyGenerator = null;
        List cacheKeyGeneratorElements = DomUtils.getChildElementsByTagName((Element)element, (String)"cacheKeyGenerator");
        if (!CollectionUtils.isEmpty((Collection)cacheKeyGeneratorElements)) {
            Element cacheKeyGeneratorElement = (Element)cacheKeyGeneratorElements.get(0);
            keyGenerator = this.beanReferenceParser.parse(cacheKeyGeneratorElement, parserContext);
        }
        return keyGenerator;
    }

    private List parseCachingListeners(Element element, ParserContext parserContext) throws IllegalStateException {
        List listenersElements = DomUtils.getChildElementsByTagName((Element)element, (String)"cachingListeners");
        if (CollectionUtils.isEmpty((Collection)listenersElements)) {
            return null;
        }
        Element listenersElement = (Element)listenersElements.get(0);
        List listenerElements = DomUtils.getChildElementsByTagName((Element)listenersElement, (String)"cachingListener");
        ManagedList listeners = new ManagedList();
        boolean registerCachingListener = true;
        int listenerCount = listenerElements.size();
        for (int i = 0; i < listenerCount; ++i) {
            Element listenerElement = (Element)listenerElements.get(i);
            Object cachingListener = this.beanReferenceParser.parse(listenerElement, parserContext, registerCachingListener);
            this.cachingListenerValidator.validate(cachingListener, i, parserContext);
            listeners.add(cachingListener);
        }
        return listeners;
    }

    private Map parseCachingModels(Element element) {
        List modelElements = DomUtils.getChildElementsByTagName((Element)element, (String)"caching");
        if (CollectionUtils.isEmpty((Collection)modelElements)) {
            return null;
        }
        String cacheModelKey = this.getCacheModelKey();
        HashMap<String, CachingModel> models = new HashMap<String, CachingModel>();
        int modelElementCount = modelElements.size();
        for (int i = 0; i < modelElementCount; ++i) {
            Element modelElement = (Element)modelElements.get(i);
            String key = modelElement.getAttribute(cacheModelKey);
            CachingModel model = this.cacheModelParser.parseCachingModel(modelElement);
            models.put(key, model);
        }
        return models;
    }

    private Map parseFlushingModels(Element element) {
        List modelElements = DomUtils.getChildElementsByTagName((Element)element, (String)"flushing");
        if (CollectionUtils.isEmpty((Collection)modelElements)) {
            return null;
        }
        String cacheModelKey = this.getCacheModelKey();
        HashMap<String, FlushingModel> models = new HashMap<String, FlushingModel>();
        int modelElementCount = modelElements.size();
        for (int i = 0; i < modelElementCount; ++i) {
            Element modelElement = (Element)modelElements.get(i);
            String key = modelElement.getAttribute(cacheModelKey);
            FlushingModel model = this.cacheModelParser.parseFlushingModel(modelElement);
            models.put(key, model);
        }
        return models;
    }
}

