/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor.caching;

import java.beans.PropertyEditor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FatalCacheException;
import org.springmodules.cache.interceptor.caching.CachingListener;
import org.springmodules.cache.interceptor.caching.CachingUtils;
import org.springmodules.cache.interceptor.caching.NullObject;
import org.springmodules.cache.key.CacheKeyGenerator;
import org.springmodules.cache.key.HashCodeCacheKeyGenerator;
import org.springmodules.cache.provider.CacheModelValidator;
import org.springmodules.cache.provider.CacheProviderFacade;

public abstract class AbstractCachingInterceptor
implements MethodInterceptor,
InitializingBean {
    public static final NullObject NULL_ENTRY = new NullObject();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CacheProviderFacade cache;
    private CacheKeyGenerator keyGenerator;
    private CachingListener[] listeners;
    private Map modelMap;

    public final void afterPropertiesSet() throws FatalCacheException {
        this.validateCache();
        if (this.modelMap instanceof Properties) {
            this.setCachingModels(this.propertiesToModels());
        }
        this.validateModels();
        if (this.keyGenerator == null) {
            this.setCacheKeyGenerator(this.defaultKeyGenerator());
        }
        this.onAfterPropertiesSet();
    }

    public final CacheKeyGenerator cacheKeyGenerator() {
        return this.keyGenerator;
    }

    public final Object invoke(MethodInvocation mi) throws Throwable {
        Method method = mi.getMethod();
        if (!CachingUtils.isCacheable(method)) {
            return this.methodNotCacheable(mi, method);
        }
        CachingModel model = this.model(mi);
        if (model == null) {
            return this.noModelFound(mi, method);
        }
        Serializable key = this.keyGenerator.generateKey(mi);
        Object cached = this.cache.getFromCache(key, model);
        if (null == cached) {
            return this.cachedValueFromSource(mi, key, model);
        }
        return this.unmaskNull(cached);
    }

    public final void setCacheKeyGenerator(CacheKeyGenerator k) {
        this.keyGenerator = k;
    }

    public final void setCacheProviderFacade(CacheProviderFacade c) {
        this.cache = c;
    }

    public final void setCachingListeners(CachingListener[] l) {
        this.listeners = l;
    }

    public final void setCachingModels(Map m) {
        this.modelMap = m;
    }

    protected abstract CachingModel model(MethodInvocation var1);

    protected final Map models() {
        return this.modelMap;
    }

    protected void onAfterPropertiesSet() throws FatalCacheException {
    }

    private Object cachedValueFromSource(MethodInvocation mi, Serializable key, CachingModel m) throws Throwable {
        boolean successful = true;
        try {
            Object value = mi.proceed();
            this.putInCache(key, m, value);
            Object object = value;
            return object;
        }
        catch (Throwable t) {
            successful = false;
            this.logger.error((Object)"Unable to proceed to the next interceptor in the chain", t);
            throw t;
        }
        finally {
            if (!successful) {
                this.cache.cancelCacheUpdate(key);
            }
        }
    }

    private CacheKeyGenerator defaultKeyGenerator() {
        return new HashCodeCacheKeyGenerator(true);
    }

    private Object logAndProceed(String message, MethodInvocation mi) throws Throwable {
        this.logger.debug((Object)message);
        return mi.proceed();
    }

    private Object maskNull(Object o) {
        return o != null ? o : NULL_ENTRY;
    }

    private Object methodNotCacheable(MethodInvocation mi, Method m) throws Throwable {
        return this.logAndProceed("Unable to perform caching. Intercepted method <" + m + "> does not return a value", mi);
    }

    private Object noModelFound(MethodInvocation mi, Method m) throws Throwable {
        return this.logAndProceed("Unable to perform caching. No model is associated to the method <" + m + ">", mi);
    }

    private void notifyListeners(Serializable key, Object cachedObject, CachingModel m) {
        if (ObjectUtils.isEmpty((Object[])this.listeners)) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].onCaching(key, cachedObject, m);
        }
    }

    private Map propertiesToModels() {
        PropertyEditor editor = this.cache.getCachingModelEditor();
        Properties properties = (Properties)this.modelMap;
        HashMap<String, Object> m = new HashMap<String, Object>();
        Iterator<Object> i = properties.keySet().iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            editor.setAsText(properties.getProperty(id));
            m.put(id, editor.getValue());
        }
        return m;
    }

    private void putInCache(Serializable key, CachingModel m, Object o) {
        this.cache.putInCache(key, m, this.maskNull(o));
        this.notifyListeners(key, o, m);
    }

    private Object unmaskNull(Object obj) {
        return NULL_ENTRY.equals(obj) ? null : obj;
    }

    private void validateCache() throws FatalCacheException {
        if (this.cache == null) {
            throw new FatalCacheException("The cache provider facade should not be null");
        }
    }

    private void validateModels() throws FatalCacheException {
        if (CollectionUtils.isEmpty((Map)this.modelMap)) {
            throw new FatalCacheException("The map of caching models should not be empty");
        }
        CacheModelValidator validator = this.cache.modelValidator();
        String id = null;
        try {
            Iterator i = this.modelMap.keySet().iterator();
            while (i.hasNext()) {
                id = (String)i.next();
                validator.validateCachingModel(this.modelMap.get(id));
            }
        }
        catch (Exception exception) {
            throw new FatalCacheException("Unable to validate caching model with id " + StringUtils.quote(id), exception);
        }
    }
}

