/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.provisioning.api.data.RoleDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleDataBinderImpl
implements RoleDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(RoleDataBinder.class);
    protected final RealmSearchDAO realmSearchDAO;
    protected final DynRealmDAO dynRealmDAO;
    protected final RoleDAO roleDAO;
    protected final EntityFactory entityFactory;
    protected final SearchCondVisitor searchCondVisitor;

    public RoleDataBinderImpl(RealmSearchDAO realmSearchDAO, DynRealmDAO dynRealmDAO, RoleDAO roleDAO, EntityFactory entityFactory, SearchCondVisitor searchCondVisitor) {
        this.realmSearchDAO = realmSearchDAO;
        this.dynRealmDAO = dynRealmDAO;
        this.roleDAO = roleDAO;
        this.entityFactory = entityFactory;
        this.searchCondVisitor = searchCondVisitor;
    }

    public Role create(RoleTO roleTO) {
        return this.update((Role)this.entityFactory.newEntity(Role.class), roleTO);
    }

    public Role update(Role toBeUpdated, RoleTO roleTO) {
        toBeUpdated.setKey(roleTO.getKey());
        Role role = (Role)this.roleDAO.save((Entity)toBeUpdated);
        role.getEntitlements().clear();
        role.getEntitlements().addAll(roleTO.getEntitlements());
        role.getRealms().clear();
        for (String realmFullPath : roleTO.getRealms()) {
            this.realmSearchDAO.findByFullPath(realmFullPath).ifPresentOrElse(arg_0 -> ((Role)role).add(arg_0), () -> LOG.debug("Invalid realm full path {}, ignoring", (Object)realmFullPath));
        }
        role.getDynRealms().clear();
        for (String key : roleTO.getDynRealms()) {
            this.dynRealmDAO.findById(key).ifPresentOrElse(arg_0 -> ((Role)role).add(arg_0), () -> LOG.debug("Invalid dynamic ream {}, ignoring", (Object)key));
        }
        role = (Role)this.roleDAO.save((Entity)role);
        this.roleDAO.clearDynMembers(role);
        if (roleTO.getDynMembershipCond() == null) {
            role.setDynMembershipCond(null);
        } else {
            if (!SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)roleTO.getDynMembershipCond(), (String[])new String[0]).isValid()) {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSearchParameters);
                sce.getElements().add(roleTO.getDynMembershipCond());
                throw sce;
            }
            role.setDynMembershipCond(roleTO.getDynMembershipCond());
        }
        return this.roleDAO.saveAndRefreshDynMemberships(role);
    }

    public RoleTO getRoleTO(Role role) {
        RoleTO roleTO = new RoleTO();
        roleTO.setKey(role.getKey());
        roleTO.getEntitlements().addAll(role.getEntitlements());
        roleTO.getRealms().addAll(role.getRealms().stream().map(Realm::getFullPath).toList());
        roleTO.getDynRealms().addAll(role.getDynRealms().stream().map(Entity::getKey).toList());
        roleTO.setDynMembershipCond(role.getDynMembershipCond());
        return roleTO;
    }
}

