/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.ipc;

public interface IpcLoggerConfig {
    public String get(String var1);

    default public String get(String key, String dflt) {
        String v = this.get(key);
        return v == null ? dflt : v;
    }

    default public int getInt(String key, int dflt) {
        int n = dflt;
        String v = this.get(key, Integer.toString(n));
        try {
            n = Integer.parseInt(v);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    default public boolean inflightMetricsEnabled() {
        String v = this.get("spectator.ipc.inflight-metrics-enabled", "true");
        return "true".equals(v);
    }

    default public int cardinalityLimit(String tagKey) {
        String propKey = "spectator.ipc.cardinality-limit." + tagKey;
        return this.getInt(propKey, 25);
    }

    default public int entryQueueSize() {
        return this.getInt("spectator.ipc.entry-queue-size", 1000);
    }
}

