/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j.web;

import com.github.scribejava.core.model.Verb;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jBaseClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationBitBucketProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationDropboxProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationFacebookProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationFoursquareProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationGitHubProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationGoogleProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationHiOrgServerProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationLinkedInProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationPayPalProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationTwitterProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationWindowsLiveProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationWordpressProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationYahooProperties;
import org.apereo.cas.configuration.model.support.pac4j.oidc.BasePac4jOidcClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.oidc.Pac4jOidcClientProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.support.pac4j.authentication.clients.ConfigurableDelegatedClient;
import org.apereo.cas.support.pac4j.authentication.clients.ConfigurableDelegatedClientBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.crypto.PrivateKeyFactoryBean;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.pac4j.core.client.BaseClient;
import org.pac4j.oauth.client.BitbucketClient;
import org.pac4j.oauth.client.DropBoxClient;
import org.pac4j.oauth.client.FacebookClient;
import org.pac4j.oauth.client.FoursquareClient;
import org.pac4j.oauth.client.GenericOAuth20Client;
import org.pac4j.oauth.client.GitHubClient;
import org.pac4j.oauth.client.Google2Client;
import org.pac4j.oauth.client.HiOrgServerClient;
import org.pac4j.oauth.client.LinkedIn2Client;
import org.pac4j.oauth.client.PayPalClient;
import org.pac4j.oauth.client.TwitterClient;
import org.pac4j.oauth.client.WindowsLiveClient;
import org.pac4j.oauth.client.WordPressClient;
import org.pac4j.oauth.client.YahooClient;
import org.pac4j.oidc.client.AppleClient;
import org.pac4j.oidc.client.AzureAd2Client;
import org.pac4j.oidc.client.GoogleOidcClient;
import org.pac4j.oidc.client.KeycloakOidcClient;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.AppleOidcConfiguration;
import org.pac4j.oidc.config.AzureAd2OidcConfiguration;
import org.pac4j.oidc.config.KeycloakOidcConfiguration;
import org.pac4j.oidc.config.OidcConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class DelegatedClientOidcBuilder
implements ConfigurableDelegatedClientBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientOidcBuilder.class);
    private final CasSSLContext casSslContext;

    public List<ConfigurableDelegatedClient> build(CasConfigurationProperties casProperties) {
        ArrayList<ConfigurableDelegatedClient> newClients = new ArrayList<ConfigurableDelegatedClient>();
        newClients.addAll(this.buildFacebookIdentityProviders(casProperties));
        newClients.addAll(this.buildOidcIdentityProviders(casProperties));
        newClients.addAll(this.buildOAuth20IdentityProviders(casProperties));
        newClients.addAll(this.buildTwitterIdentityProviders(casProperties));
        newClients.addAll(this.buildDropBoxIdentityProviders(casProperties));
        newClients.addAll(this.buildFoursquareIdentityProviders(casProperties));
        newClients.addAll(this.buildGitHubIdentityProviders(casProperties));
        newClients.addAll(this.buildGoogleIdentityProviders(casProperties));
        newClients.addAll(this.buildWindowsLiveIdentityProviders(casProperties));
        newClients.addAll(this.buildYahooIdentityProviders(casProperties));
        newClients.addAll(this.buildLinkedInIdentityProviders(casProperties));
        newClients.addAll(this.buildPaypalIdentityProviders(casProperties));
        newClients.addAll(this.buildWordpressIdentityProviders(casProperties));
        newClients.addAll(this.buildBitBucketIdentityProviders(casProperties));
        newClients.addAll(this.buildHiOrgServerIdentityProviders(casProperties));
        return newClients;
    }

    protected Collection<ConfigurableDelegatedClient> buildFoursquareIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationFoursquareProperties foursquare = pac4jProperties.getFoursquare();
        if (foursquare.isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)foursquare.getId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)foursquare.getSecret())) {
            FoursquareClient client = new FoursquareClient(foursquare.getId(), foursquare.getSecret());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)foursquare));
        }
        return List.of();
    }

    protected Collection<ConfigurableDelegatedClient> buildGoogleIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationGoogleProperties google = pac4jProperties.getGoogle();
        if (google.isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)google.getId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)google.getSecret())) {
            Google2Client client = new Google2Client(google.getId(), google.getSecret());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)google.getScope())) {
                client.setScope(Google2Client.Google2Scope.valueOf((String)google.getScope().toUpperCase(Locale.ENGLISH)));
            }
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)google));
        }
        return List.of();
    }

    protected Collection<ConfigurableDelegatedClient> buildFacebookIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationFacebookProperties fb = pac4jProperties.getFacebook();
        if (fb.isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fb.getId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fb.getSecret())) {
            FacebookClient client = new FacebookClient(fb.getId(), fb.getSecret());
            FunctionUtils.doIfNotBlank((CharSequence)fb.getScope(), __ -> client.setScope(fb.getScope()));
            FunctionUtils.doIfNotBlank((CharSequence)fb.getFields(), __ -> client.setFields(fb.getFields()));
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)fb));
        }
        return List.of();
    }

    protected Collection<ConfigurableDelegatedClient> buildLinkedInIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationLinkedInProperties ln = pac4jProperties.getLinkedIn();
        if (ln.isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ln.getId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ln.getSecret())) {
            LinkedIn2Client client = new LinkedIn2Client(ln.getId(), ln.getSecret());
            FunctionUtils.doIfNotBlank((CharSequence)ln.getScope(), __ -> client.setScope(ln.getScope()));
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)ln));
        }
        return List.of();
    }

    protected Collection<ConfigurableDelegatedClient> buildGitHubIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationGitHubProperties github = pac4jProperties.getGithub();
        if (github.isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)github.getId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)github.getSecret())) {
            GitHubClient client = new GitHubClient(github.getId(), github.getSecret());
            FunctionUtils.doIfNotBlank((CharSequence)github.getScope(), __ -> client.setScope(github.getScope()));
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)github));
        }
        return List.of();
    }

    protected Collection<ConfigurableDelegatedClient> buildDropBoxIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationDropboxProperties db = pac4jProperties.getDropbox();
        if (db.isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)db.getId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)db.getSecret())) {
            DropBoxClient client = new DropBoxClient(db.getId(), db.getSecret());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)db));
        }
        return List.of();
    }

    protected Collection<ConfigurableDelegatedClient> buildWindowsLiveIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationWindowsLiveProperties live = pac4jProperties.getWindowsLive();
        if (live.isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)live.getId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)live.getSecret())) {
            WindowsLiveClient client = new WindowsLiveClient(live.getId(), live.getSecret());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)live));
        }
        return List.of();
    }

    protected Collection<ConfigurableDelegatedClient> buildYahooIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationYahooProperties yahoo = pac4jProperties.getYahoo();
        if (yahoo.isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)yahoo.getId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)yahoo.getSecret())) {
            YahooClient client = new YahooClient(yahoo.getId(), yahoo.getSecret());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)yahoo));
        }
        return List.of();
    }

    protected Collection<ConfigurableDelegatedClient> buildHiOrgServerIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationHiOrgServerProperties hiOrgServer = pac4jProperties.getHiOrgServer();
        if (hiOrgServer.isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)hiOrgServer.getId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)hiOrgServer.getSecret())) {
            HiOrgServerClient client = new HiOrgServerClient(hiOrgServer.getId(), hiOrgServer.getSecret());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)hiOrgServer.getScope())) {
                client.getConfiguration().setScope(hiOrgServer.getScope());
            }
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)hiOrgServer));
        }
        return List.of();
    }

    protected Collection<ConfigurableDelegatedClient> buildOAuth20IdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        return pac4jProperties.getOauth2().stream().filter(oauth -> oauth.isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)oauth.getId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)oauth.getSecret())).map(oauth -> {
            GenericOAuth20Client client = new GenericOAuth20Client();
            client.setProfileId((String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)oauth.getPrincipalIdAttribute(), (CharSequence)pac4jProperties.getCore().getPrincipalIdAttribute()));
            client.setKey(SpringExpressionLanguageValueResolver.getInstance().resolve(oauth.getId()));
            client.setSecret(SpringExpressionLanguageValueResolver.getInstance().resolve(oauth.getSecret()));
            client.setProfileAttrs(oauth.getProfileAttrs());
            client.setProfileUrl(oauth.getProfileUrl());
            client.setProfileVerb(Verb.valueOf((String)oauth.getProfileVerb().toUpperCase(Locale.ENGLISH)));
            client.setTokenUrl(oauth.getTokenUrl());
            client.setAuthUrl(oauth.getAuthUrl());
            client.setScope(oauth.getScope());
            client.setCustomParams(oauth.getCustomParams());
            client.setWithState(oauth.isWithState());
            FunctionUtils.doIfNotBlank((CharSequence)oauth.getClientAuthenticationMethod(), arg_0 -> ((GenericOAuth20Client)client).setClientAuthenticationMethod(arg_0));
            client.getConfiguration().setResponseType(oauth.getResponseType());
            LOGGER.debug("Created client [{}]", (Object)client);
            return new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)oauth);
        }).collect(Collectors.toList());
    }

    protected Collection<ConfigurableDelegatedClient> buildOidcIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        return pac4jProperties.getOidc().stream().map(this::getOidcClientFrom).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected Collection<ConfigurableDelegatedClient> buildWordpressIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationWordpressProperties wp = pac4jProperties.getWordpress();
        if (wp.isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)wp.getId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)wp.getSecret())) {
            WordPressClient client = new WordPressClient(wp.getId(), wp.getSecret());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)wp));
        }
        return List.of();
    }

    protected Collection<ConfigurableDelegatedClient> buildTwitterIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationTwitterProperties twitter = pac4jProperties.getTwitter();
        if (twitter.isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)twitter.getId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)twitter.getSecret())) {
            TwitterClient client = new TwitterClient(twitter.getId(), twitter.getSecret(), twitter.isIncludeEmail());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)twitter));
        }
        return List.of();
    }

    private ConfigurableDelegatedClient getOidcClientFrom(Pac4jOidcClientProperties clientProperties) {
        SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
        if (clientProperties.getAzure().isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)clientProperties.getAzure().getId())) {
            LOGGER.debug("Building OpenID Connect client for Azure AD...");
            AzureAd2OidcConfiguration azure = this.getOidcConfigurationForClient((BasePac4jOidcClientProperties)clientProperties.getAzure(), AzureAd2OidcConfiguration.class);
            azure.setTenant(resolver.resolve(clientProperties.getAzure().getTenant()));
            AzureAd2OidcConfiguration cfg = new AzureAd2OidcConfiguration((OidcConfiguration)azure);
            return new ConfigurableDelegatedClient((BaseClient)new AzureAd2Client(cfg), (Pac4jBaseClientProperties)clientProperties.getAzure());
        }
        if (clientProperties.getGoogle().isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)clientProperties.getGoogle().getId())) {
            LOGGER.debug("Building OpenID Connect client for Google...");
            OidcConfiguration cfg = this.getOidcConfigurationForClient((BasePac4jOidcClientProperties)clientProperties.getGoogle(), OidcConfiguration.class);
            return new ConfigurableDelegatedClient((BaseClient)new GoogleOidcClient(cfg), (Pac4jBaseClientProperties)clientProperties.getGoogle());
        }
        if (clientProperties.getKeycloak().isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)clientProperties.getKeycloak().getId())) {
            LOGGER.debug("Building OpenID Connect client for KeyCloak...");
            KeycloakOidcConfiguration cfg = this.getOidcConfigurationForClient((BasePac4jOidcClientProperties)clientProperties.getKeycloak(), KeycloakOidcConfiguration.class);
            cfg.setRealm(resolver.resolve(clientProperties.getKeycloak().getRealm()));
            cfg.setBaseUri(resolver.resolve(clientProperties.getKeycloak().getBaseUri()));
            return new ConfigurableDelegatedClient((BaseClient)new KeycloakOidcClient(cfg), (Pac4jBaseClientProperties)clientProperties.getKeycloak());
        }
        if (clientProperties.getApple().isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)clientProperties.getApple().getPrivateKey())) {
            LOGGER.debug("Building OpenID Connect client for Apple...");
            AppleOidcConfiguration cfg = this.getOidcConfigurationForClient((BasePac4jOidcClientProperties)clientProperties.getApple(), AppleOidcConfiguration.class);
            FunctionUtils.doUnchecked(__ -> {
                PrivateKeyFactoryBean factory = new PrivateKeyFactoryBean();
                factory.setAlgorithm("EC");
                factory.setSingleton(false);
                factory.setLocation((Resource)ResourceUtils.getResourceFrom((String)clientProperties.getApple().getPrivateKey()));
                cfg.setPrivateKey((ECPrivateKey)factory.getObject());
            }, (Object[])new Object[0]);
            cfg.setPrivateKeyID(clientProperties.getApple().getPrivateKeyId());
            cfg.setTeamID(clientProperties.getApple().getTeamId());
            cfg.setTimeout(Beans.newDuration((String)clientProperties.getApple().getTimeout()));
            return new ConfigurableDelegatedClient((BaseClient)new AppleClient(cfg), (Pac4jBaseClientProperties)clientProperties.getApple());
        }
        if (clientProperties.getGeneric().isEnabled()) {
            LOGGER.debug("Building generic OpenID Connect client...");
            OidcConfiguration generic = this.getOidcConfigurationForClient((BasePac4jOidcClientProperties)clientProperties.getGeneric(), OidcConfiguration.class);
            return new ConfigurableDelegatedClient((BaseClient)new OidcClient(generic), (Pac4jBaseClientProperties)clientProperties.getGeneric());
        }
        return null;
    }

    protected Collection<ConfigurableDelegatedClient> buildPaypalIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationPayPalProperties paypal = pac4jProperties.getPaypal();
        if (paypal.isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)paypal.getId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)paypal.getSecret())) {
            PayPalClient client = new PayPalClient(paypal.getId(), paypal.getSecret());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)paypal));
        }
        return List.of();
    }

    private <T extends OidcConfiguration> T getOidcConfigurationForClient(BasePac4jOidcClientProperties oidc, Class<T> clazz) {
        SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
        OidcConfiguration cfg = (OidcConfiguration)FunctionUtils.doUnchecked(() -> (OidcConfiguration)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        FunctionUtils.doIfNotBlank((CharSequence)oidc.getScope(), __ -> cfg.setScope(resolver.resolve(oidc.getScope())));
        cfg.setUseNonce(oidc.isUseNonce());
        cfg.setDisablePkce(oidc.isDisablePkce());
        cfg.setSecret(resolver.resolve(oidc.getSecret()));
        cfg.setClientId(resolver.resolve(oidc.getId()));
        cfg.setReadTimeout((int)Beans.newDuration((String)oidc.getReadTimeout()).toMillis());
        cfg.setConnectTimeout((int)Beans.newDuration((String)oidc.getConnectTimeout()).toMillis());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)oidc.getPreferredJwsAlgorithm())) {
            cfg.setPreferredJwsAlgorithm(JWSAlgorithm.parse((String)oidc.getPreferredJwsAlgorithm().toUpperCase(Locale.ENGLISH)));
        }
        cfg.setMaxClockSkew(Long.valueOf(Beans.newDuration((String)oidc.getMaxClockSkew()).toSeconds()).intValue());
        cfg.setDiscoveryURI(oidc.getDiscoveryUri());
        cfg.setCustomParams(oidc.getCustomParams());
        cfg.setLogoutUrl(oidc.getLogoutUrl());
        cfg.setAllowUnsignedIdTokens(oidc.isAllowUnsignedIdTokens());
        cfg.setIncludeAccessTokenClaimsInProfile(oidc.isIncludeAccessTokenClaims());
        cfg.setExpireSessionWithToken(oidc.isExpireSessionWithToken());
        cfg.setLogoutValidation(oidc.isValidateLogoutToken());
        FunctionUtils.doIfNotBlank((CharSequence)oidc.getSupportedClientAuthenticationMethods(), methods -> {
            Set clientMethods = StringUtils.commaDelimitedListToSet((String)methods).stream().map(ClientAuthenticationMethod::parse).collect(Collectors.toSet());
            cfg.setSupportedClientAuthenticationMethods(clientMethods);
        });
        FunctionUtils.doIfNotBlank((CharSequence)oidc.getClientAuthenticationMethod(), method -> cfg.setClientAuthenticationMethod(ClientAuthenticationMethod.parse((String)method)));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)oidc.getTokenExpirationAdvance())) {
            cfg.setTokenExpirationAdvance((int)Beans.newDuration((String)oidc.getTokenExpirationAdvance()).toSeconds());
        }
        FunctionUtils.doIfNotBlank((CharSequence)oidc.getResponseMode(), __ -> cfg.setResponseMode(oidc.getResponseMode()));
        FunctionUtils.doIfNotBlank((CharSequence)oidc.getResponseType(), __ -> cfg.setResponseType(oidc.getResponseType()));
        if (!oidc.getMappedClaims().isEmpty()) {
            cfg.setMappedClaims(CollectionUtils.convertDirectedListToMap((Collection)oidc.getMappedClaims()));
        }
        cfg.setSslSocketFactory(this.casSslContext.getSslContext().getSocketFactory());
        cfg.setHostnameVerifier(this.casSslContext.getHostnameVerifier());
        return (T)cfg;
    }

    protected Collection<ConfigurableDelegatedClient> buildBitBucketIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationBitBucketProperties bitbucket = pac4jProperties.getBitbucket();
        if (bitbucket.isEnabled() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bitbucket.getId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)bitbucket.getSecret())) {
            BitbucketClient client = new BitbucketClient(bitbucket.getId(), bitbucket.getSecret());
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)bitbucket));
        }
        return List.of();
    }

    @Generated
    public DelegatedClientOidcBuilder(CasSSLContext casSslContext) {
        this.casSslContext = casSslContext;
    }
}

