/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateKeyUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrivateKeyUtils.class);

    public static PrivateKey createKey(String path, String algorithm) {
        PrivateKey key = PrivateKeyUtils.readPemPrivateKey(path);
        if (key == null) {
            return PrivateKeyUtils.readDERPrivateKey(path, algorithm);
        }
        return key;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static PrivateKey readPemPrivateKey(String path) {
        LOGGER.debug("Attempting to read as PEM [{}]", (Object)path);
        File file = new File(path);
        try (FileReader isr = new FileReader(file);){
            PrivateKey privateKey;
            try (BufferedReader br = new BufferedReader(isr);){
                PEMParser pp = new PEMParser((Reader)br);
                PEMKeyPair pemKeyPair = (PEMKeyPair)pp.readObject();
                KeyPair kp = new JcaPEMKeyConverter().getKeyPair(pemKeyPair);
                privateKey = kp.getPrivate();
            }
            return privateKey;
        }
        catch (Exception e) {
            LOGGER.error("Unable to read key", (Throwable)e);
            return null;
        }
    }

    private static PrivateKey readDERPrivateKey(String path, String algorithm) {
        PrivateKey privateKey;
        LOGGER.debug("Attempting to read key as DER [{}]", (Object)path);
        File file = new File(path);
        FileInputStream fis = new FileInputStream(file);
        try {
            long byteLength = file.length();
            byte[] bytes = new byte[(int)byteLength];
            fis.read(bytes, 0, (int)byteLength);
            PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(algorithm);
            privateKey = factory.generatePrivate(privSpec);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Unable to read key", (Throwable)e);
                return null;
            }
        }
        fis.close();
        return privateKey;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

