/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.message.BasicHeaderElementIterator;
import org.apache.hc.core5.http.message.BasicHeaderValueFormatter;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.net.PercentCodec;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.TextUtils;

@Contract(threading=ThreadingBehavior.STATELESS)
public class CacheKeyGenerator
implements Resolver<URI, String> {
    public static final CacheKeyGenerator INSTANCE = new CacheKeyGenerator();

    public String resolve(URI uri) {
        return this.generateKey(uri);
    }

    @Internal
    public static String getRequestUri(HttpHost target, HttpRequest request) {
        Args.notNull((Object)target, (String)"Target");
        Args.notNull((Object)request, (String)"HTTP request");
        StringBuilder buf = new StringBuilder();
        URIAuthority authority = request.getAuthority();
        if (authority != null) {
            String scheme = request.getScheme();
            buf.append(scheme != null ? scheme : URIScheme.HTTP.id).append("://");
            buf.append(authority.getHostName());
            if (authority.getPort() >= 0) {
                buf.append(":").append(authority.getPort());
            }
        } else {
            buf.append(target.getSchemeName()).append("://");
            buf.append(target.getHostName());
            if (target.getPort() >= 0) {
                buf.append(":").append(target.getPort());
            }
        }
        String path = request.getPath();
        if (path == null) {
            buf.append("/");
        } else {
            if (buf.length() > 0 && !path.startsWith("/")) {
                buf.append("/");
            }
            buf.append(path);
        }
        return buf.toString();
    }

    @Internal
    public static URI normalize(URI requestUri) throws URISyntaxException {
        Args.notNull((Object)requestUri, (String)"URI");
        URIBuilder builder = new URIBuilder(requestUri);
        if (builder.getHost() != null) {
            if (builder.getScheme() == null) {
                builder.setScheme(URIScheme.HTTP.id);
            }
            if (builder.getPort() <= -1) {
                if (URIScheme.HTTP.same(builder.getScheme())) {
                    builder.setPort(80);
                } else if (URIScheme.HTTPS.same(builder.getScheme())) {
                    builder.setPort(443);
                }
            }
        }
        builder.setFragment(null);
        return builder.optimize().build();
    }

    @Internal
    public static URI normalize(String requestUri) {
        if (requestUri == null) {
            return null;
        }
        try {
            return CacheKeyGenerator.normalize(new URI(requestUri));
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public String generateKey(URI requestUri) {
        try {
            URI normalizeRequestUri = CacheKeyGenerator.normalize(requestUri);
            return normalizeRequestUri.toASCIIString();
        }
        catch (URISyntaxException ex) {
            return requestUri.toASCIIString();
        }
    }

    public String generateKey(HttpHost host, HttpRequest request) {
        String s = CacheKeyGenerator.getRequestUri(host, request);
        try {
            return this.generateKey(new URI(s));
        }
        catch (URISyntaxException ex) {
            return s;
        }
    }

    public static List<String> variantNames(MessageHeaders message) {
        if (message == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        Iterator it = message.headerIterator("Vary");
        while (it.hasNext()) {
            Header header = (Header)it.next();
            MessageSupport.parseTokens((Header)header, names::add);
        }
        return names;
    }

    @Internal
    public static void normalizeElements(MessageHeaders message, String headerName, Consumer<String> consumer) {
        if (headerName.equalsIgnoreCase("User-Agent")) {
            Header header = message.getFirstHeader(headerName);
            if (header != null) {
                consumer.accept(header.getValue().toLowerCase(Locale.ROOT));
            }
        } else {
            CacheKeyGenerator.normalizeElements(message.headerIterator(headerName), consumer);
        }
    }

    @Internal
    public static void normalizeElements(Iterator<Header> iterator, Consumer<String> consumer) {
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(iterator);
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 256), false).filter(e -> !TextUtils.isBlank((CharSequence)e.getName())).map(e -> {
            if (e.getValue() == null && e.getParameterCount() == 0) {
                return e.getName().toLowerCase(Locale.ROOT);
            }
            CharArrayBuffer buf = new CharArrayBuffer(1024);
            BasicHeaderValueFormatter.INSTANCE.formatNameValuePair(buf, (NameValuePair)new BasicNameValuePair(e.getName().toLowerCase(Locale.ROOT), !TextUtils.isBlank((CharSequence)e.getValue()) ? e.getValue() : null), false);
            if (e.getParameterCount() > 0) {
                for (NameValuePair nvp : e.getParameters()) {
                    if (TextUtils.isBlank((CharSequence)nvp.getName())) continue;
                    buf.append(';');
                    BasicHeaderValueFormatter.INSTANCE.formatNameValuePair(buf, (NameValuePair)new BasicNameValuePair(nvp.getName().toLowerCase(Locale.ROOT), !TextUtils.isBlank((CharSequence)nvp.getValue()) ? nvp.getValue() : null), false);
                }
            }
            return buf.toString();
        }).sorted().distinct().forEach(consumer);
    }

    public String generateVariantKey(HttpRequest request, Collection<String> variantNames) {
        Args.notNull(variantNames, (String)"Variant names");
        StringBuilder buf = new StringBuilder("{");
        AtomicBoolean firstHeader = new AtomicBoolean();
        variantNames.stream().map(h -> h.toLowerCase(Locale.ROOT)).sorted().distinct().forEach(h -> {
            if (!firstHeader.compareAndSet(false, true)) {
                buf.append("&");
            }
            buf.append(PercentCodec.encode((CharSequence)h, (Charset)StandardCharsets.UTF_8)).append("=");
            AtomicBoolean firstToken = new AtomicBoolean();
            CacheKeyGenerator.normalizeElements((MessageHeaders)request, h, t -> {
                if (!firstToken.compareAndSet(false, true)) {
                    buf.append(",");
                }
                buf.append(PercentCodec.encode((CharSequence)t, (Charset)StandardCharsets.UTF_8));
            });
        });
        buf.append("}");
        return buf.toString();
    }

    public String generateVariantKey(HttpRequest request, HttpCacheEntry entry) {
        if (entry.containsHeader("Vary")) {
            List<String> variantNames = CacheKeyGenerator.variantNames(entry);
            return this.generateVariantKey(request, variantNames);
        }
        return null;
    }

    @Deprecated
    public String generateKey(HttpHost host, HttpRequest request, HttpCacheEntry entry) {
        String rootKey = this.generateKey(host, request);
        List<String> variantNames = CacheKeyGenerator.variantNames(entry);
        if (variantNames.isEmpty()) {
            return rootKey;
        }
        return this.generateVariantKey(request, variantNames) + rootKey;
    }
}

