/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.scripting;

import java.util.Objects;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.scripting.ScriptEngineRequest;
import org.flowable.common.engine.impl.scripting.ScriptingEngines;

public abstract class AbstractScriptEvaluator {
    private static final long serialVersionUID = -8915149072831499057L;
    protected Expression language;
    protected String script;
    protected Expression resultVariable;

    public AbstractScriptEvaluator() {
    }

    public AbstractScriptEvaluator(Expression language, String script) {
        this.script = script;
        this.language = language;
    }

    public ScriptEngineRequest.Builder createScriptRequest(VariableContainer variableContainer) {
        this.validateParameters();
        String language = Objects.toString(this.language.getValue(variableContainer), null);
        if (language == null) {
            throw new FlowableIllegalStateException("'language' evaluated to null for listener of type 'script'");
        }
        ScriptEngineRequest.Builder builder = ScriptEngineRequest.builder();
        return builder.language(language).script(this.getScript()).scopeContainer(variableContainer);
    }

    protected Object evaluateScriptRequest(ScriptEngineRequest.Builder requestBuilder) {
        ScriptEngineRequest request = requestBuilder.build();
        Object result = this.evaluateScript(this.getScriptingEngines(), request);
        if (this.resultVariable != null) {
            VariableContainer variableContainer = request.getScopeContainer();
            String resultVariable = Objects.toString(this.resultVariable.getValue(variableContainer), null);
            if (variableContainer != null && resultVariable != null) {
                variableContainer.setVariable(resultVariable, result);
            }
        }
        return result;
    }

    protected Object evaluateScript(ScriptingEngines scriptingEngines, ScriptEngineRequest request) {
        return scriptingEngines.evaluate(request).getResult();
    }

    protected void validateParameters() {
        if (this.script == null) {
            throw new FlowableIllegalStateException("The field 'script' should be set on " + this.getClass().getSimpleName());
        }
        if (this.language == null) {
            throw new FlowableIllegalStateException("The field 'language' should be set on " + this.getClass().getSimpleName());
        }
    }

    protected abstract ScriptingEngines getScriptingEngines();

    public void setScript(String script) {
        this.script = script;
    }

    public void setScript(Expression script) {
        this.script = script.getExpressionText();
    }

    public String getScript() {
        return this.script;
    }

    public void setLanguage(Expression language) {
        this.language = language;
    }

    public void setResultVariable(Expression resultVariable) {
        this.resultVariable = resultVariable;
    }
}

