/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.Map;
import java.util.Optional;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcDiscoveryProperties;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.callback.DefaultOAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20ResponseModeFactory;

public class OidcAuthorizationModelAndViewBuilder
extends DefaultOAuth20AuthorizationModelAndViewBuilder {
    private final OidcIssuerService issuerService;
    private final CasConfigurationProperties casProperties;

    public OidcAuthorizationModelAndViewBuilder(OAuth20ResponseModeFactory responseModeFactory, OidcIssuerService issuerService, CasConfigurationProperties casProperties) {
        super(responseModeFactory);
        this.issuerService = issuerService;
        this.casProperties = casProperties;
    }

    protected String prepareRedirectUrl(OAuthRegisteredService registeredService, String redirectUrl, Map<String, String> parameters) throws Exception {
        OidcDiscoveryProperties discovery = this.casProperties.getAuthn().getOidc().getDiscovery();
        if (registeredService instanceof OidcRegisteredService) {
            OidcRegisteredService oidcService = (OidcRegisteredService)registeredService;
            if (discovery.isAuthorizationResponseIssuerParameterSupported()) {
                String issuer = this.issuerService.determineIssuer(Optional.of(oidcService));
                parameters.put("iss", issuer);
                return new URIBuilder(redirectUrl).addParameter("iss", issuer).build().toString();
            }
        }
        return super.prepareRedirectUrl(registeredService, redirectUrl, parameters);
    }
}

