/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.io.Serializable;
import java.util.LinkedHashMap;

public final class SearchResult
implements Serializable {
    private static final long serialVersionUID = 629759587906070073L;
    private final String pagedResultsCookie;
    private final int remainingPagedResults;
    private final boolean allResultsReturned;

    public SearchResult() {
        this(null, -1, true);
    }

    public SearchResult(String pagedResultsCookie, int remainingPagedResults) {
        this(pagedResultsCookie, remainingPagedResults, true);
    }

    public SearchResult(String pagedResultsCookie, int remainingPagedResults, boolean allResultsReturned) {
        this.pagedResultsCookie = pagedResultsCookie;
        this.remainingPagedResults = remainingPagedResults;
        this.allResultsReturned = allResultsReturned;
    }

    public String getPagedResultsCookie() {
        return this.pagedResultsCookie;
    }

    public int getRemainingPagedResults() {
        return this.remainingPagedResults;
    }

    public boolean isAllResultsReturned() {
        return this.allResultsReturned;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("SearchResult: ");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("PagedResultsCookie", this.getPagedResultsCookie());
        map.put("RemainingPagedResults", this.getRemainingPagedResults());
        map.put("AllResultsReturned", this.isAllResultsReturned());
        bld.append(map);
        return bld.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allResultsReturned ? 1231 : 1237);
        result = 31 * result + (this.pagedResultsCookie == null ? 0 : this.pagedResultsCookie.hashCode());
        result = 31 * result + this.remainingPagedResults;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchResult other = (SearchResult)obj;
        if (this.allResultsReturned != other.allResultsReturned) {
            return false;
        }
        if (this.pagedResultsCookie == null ? other.pagedResultsCookie != null : !this.pagedResultsCookie.equals(other.pagedResultsCookie)) {
            return false;
        }
        return this.remainingPagedResults == other.remainingPagedResults;
    }
}

