/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.CoordsGeoBounds;
import co.elastic.clients.elasticsearch._types.TopLeftBottomRightGeoBounds;
import co.elastic.clients.elasticsearch._types.TopRightBottomLeftGeoBounds;
import co.elastic.clients.elasticsearch._types.WktGeoBounds;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class GeoBounds
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<GeoBounds> _DESERIALIZER = JsonpDeserializer.lazy(GeoBounds::buildGeoBoundsDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private GeoBounds(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private GeoBounds(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static GeoBounds of(Function<Builder, ObjectBuilder<GeoBounds>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCoords() {
        return this._kind == Kind.Coords;
    }

    public CoordsGeoBounds coords() {
        return (CoordsGeoBounds)TaggedUnionUtils.get(this, Kind.Coords);
    }

    public boolean isTlbr() {
        return this._kind == Kind.Tlbr;
    }

    public TopLeftBottomRightGeoBounds tlbr() {
        return (TopLeftBottomRightGeoBounds)TaggedUnionUtils.get(this, Kind.Tlbr);
    }

    public boolean isTrbl() {
        return this._kind == Kind.Trbl;
    }

    public TopRightBottomLeftGeoBounds trbl() {
        return (TopRightBottomLeftGeoBounds)TaggedUnionUtils.get(this, Kind.Trbl);
    }

    public boolean isWkt() {
        return this._kind == Kind.Wkt;
    }

    public WktGeoBounds wkt() {
        return (WktGeoBounds)TaggedUnionUtils.get(this, Kind.Wkt);
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    private static JsonpDeserializer<GeoBounds> buildGeoBoundsDeserializer() {
        return new UnionDeserializer.Builder(GeoBounds::new, false).addMember((Object)Kind.Coords, CoordsGeoBounds._DESERIALIZER).addMember((Object)Kind.Tlbr, TopLeftBottomRightGeoBounds._DESERIALIZER).addMember((Object)Kind.Trbl, TopRightBottomLeftGeoBounds._DESERIALIZER).addMember((Object)Kind.Wkt, WktGeoBounds._DESERIALIZER).build();
    }

    public static enum Kind {
        Coords,
        Tlbr,
        Trbl,
        Wkt;

    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GeoBounds> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<GeoBounds> coords(CoordsGeoBounds v) {
            this._kind = Kind.Coords;
            this._value = v;
            return this;
        }

        public ObjectBuilder<GeoBounds> coords(Function<CoordsGeoBounds.Builder, ObjectBuilder<CoordsGeoBounds>> fn) {
            return this.coords(fn.apply(new CoordsGeoBounds.Builder()).build());
        }

        public ObjectBuilder<GeoBounds> tlbr(TopLeftBottomRightGeoBounds v) {
            this._kind = Kind.Tlbr;
            this._value = v;
            return this;
        }

        public ObjectBuilder<GeoBounds> tlbr(Function<TopLeftBottomRightGeoBounds.Builder, ObjectBuilder<TopLeftBottomRightGeoBounds>> fn) {
            return this.tlbr(fn.apply(new TopLeftBottomRightGeoBounds.Builder()).build());
        }

        public ObjectBuilder<GeoBounds> trbl(TopRightBottomLeftGeoBounds v) {
            this._kind = Kind.Trbl;
            this._value = v;
            return this;
        }

        public ObjectBuilder<GeoBounds> trbl(Function<TopRightBottomLeftGeoBounds.Builder, ObjectBuilder<TopRightBottomLeftGeoBounds>> fn) {
            return this.trbl(fn.apply(new TopRightBottomLeftGeoBounds.Builder()).build());
        }

        public ObjectBuilder<GeoBounds> wkt(WktGeoBounds v) {
            this._kind = Kind.Wkt;
            this._value = v;
            return this;
        }

        public ObjectBuilder<GeoBounds> wkt(Function<WktGeoBounds.Builder, ObjectBuilder<WktGeoBounds>> fn) {
            return this.wkt(fn.apply(new WktGeoBounds.Builder()).build());
        }

        @Override
        public GeoBounds build() {
            this._checkSingleUse();
            return new GeoBounds(this);
        }
    }
}

