/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime.dto;

import jakarta.servlet.DispatcherType;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.registry.HandlerRegistry;
import org.apache.felix.http.base.internal.registry.PathResolution;
import org.apache.felix.http.base.internal.runtime.dto.FilterDTOBuilder;
import org.apache.felix.http.base.internal.runtime.dto.ResourceDTOBuilder;
import org.apache.felix.http.base.internal.runtime.dto.ServletDTOBuilder;
import org.osgi.service.servlet.runtime.dto.FilterDTO;
import org.osgi.service.servlet.runtime.dto.RequestInfoDTO;

public final class RequestInfoDTOBuilder {
    private static final FilterDTO[] FILTER_DTO_ARRAY = new FilterDTO[0];
    private final HandlerRegistry registry;
    private final String path;

    public RequestInfoDTOBuilder(HandlerRegistry registry, String path) {
        this.registry = registry;
        this.path = path;
    }

    public RequestInfoDTO build() {
        RequestInfoDTO requestInfoDTO = new RequestInfoDTO();
        requestInfoDTO.path = this.path;
        PathResolution pr = this.registry.resolveServlet(this.path);
        if (pr == null) {
            requestInfoDTO.filterDTOs = FILTER_DTO_ARRAY;
            return requestInfoDTO;
        }
        requestInfoDTO.servletContextId = pr.handler.getContextServiceId();
        if (pr.handler.getServletInfo().isResource()) {
            requestInfoDTO.resourceDTO = ResourceDTOBuilder.build(pr.handler, -1);
            requestInfoDTO.resourceDTO.patterns = pr.patterns;
        } else {
            requestInfoDTO.servletDTO = ServletDTOBuilder.build(pr.handler, -1);
            requestInfoDTO.servletDTO.patterns = pr.patterns;
        }
        FilterHandler[] filterHandlers = this.registry.getFilters(pr, DispatcherType.REQUEST, this.path);
        requestInfoDTO.filterDTOs = FilterDTOBuilder.build(filterHandlers);
        return requestInfoDTO;
    }
}

