/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker;

import java.io.BufferedInputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.broker.ConfigContext;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.store.config.MessageStoreConfig;

public class BrokerStartup {
    public static Logger log;

    public static void main(String[] args) {
        BrokerStartup.start(BrokerStartup.createBrokerController(args));
    }

    public static BrokerController start(BrokerController controller) {
        try {
            controller.start();
            String tip = String.format("The broker[%s, %s] boot success. serializeType=%s", controller.getBrokerConfig().getBrokerName(), controller.getBrokerAddr(), RemotingCommand.getSerializeTypeConfigInThisServer());
            if (null != controller.getBrokerConfig().getNamesrvAddr()) {
                tip = tip + " and name server is " + controller.getBrokerConfig().getNamesrvAddr();
            }
            log.info(tip);
            System.out.printf("%s%n", tip);
            return controller;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static void shutdown(BrokerController controller) {
        if (null != controller) {
            controller.shutdown();
        }
    }

    public static ConfigContext parseCmdLine(String[] args) throws Exception {
        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
        CommandLine commandLine = ServerUtil.parseCmdLine((String)"mqbroker", (String[])args, (Options)BrokerStartup.buildCommandlineOptions(options), (CommandLineParser)new DefaultParser());
        if (null == commandLine) {
            System.exit(-1);
        }
        String filePath = null;
        if (commandLine.hasOption('c')) {
            filePath = commandLine.getOptionValue('c');
        }
        ConfigContext configContext = BrokerStartup.configFileToConfigContext(filePath);
        if (commandLine.hasOption('p') && configContext != null) {
            Logger console = LoggerFactory.getLogger((String)"RocketmqConsole");
            MixAll.printObjectProperties((Logger)console, (Object)configContext.getBrokerConfig());
            MixAll.printObjectProperties((Logger)console, (Object)configContext.getNettyServerConfig());
            MixAll.printObjectProperties((Logger)console, (Object)configContext.getNettyClientConfig());
            MixAll.printObjectProperties((Logger)console, (Object)configContext.getAuthConfig());
            System.exit(0);
        } else if (commandLine.hasOption('m') && configContext != null) {
            Logger console = LoggerFactory.getLogger((String)"RocketmqConsole");
            MixAll.printObjectProperties((Logger)console, (Object)configContext.getBrokerConfig(), (boolean)true);
            MixAll.printObjectProperties((Logger)console, (Object)configContext.getNettyServerConfig(), (boolean)true);
            MixAll.printObjectProperties((Logger)console, (Object)configContext.getNettyClientConfig(), (boolean)true);
            MixAll.printObjectProperties((Logger)console, (Object)configContext.getAuthConfig(), (boolean)true);
            System.exit(0);
        }
        assert (configContext != null);
        MixAll.properties2Object((Properties)ServerUtil.commandLine2Properties((CommandLine)commandLine), (Object)configContext.getBrokerConfig());
        return configContext;
    }

    public static ConfigContext configFileToConfigContext(String filePath) throws Exception {
        SystemConfigFileHelper systemConfigFileHelper = new SystemConfigFileHelper();
        BrokerConfig brokerConfig = new BrokerConfig();
        NettyServerConfig nettyServerConfig = new NettyServerConfig();
        NettyClientConfig nettyClientConfig = new NettyClientConfig();
        MessageStoreConfig messageStoreConfig = new MessageStoreConfig();
        AuthConfig authConfig = new AuthConfig();
        nettyServerConfig.setListenPort(10911);
        messageStoreConfig.setHaListenPort(0);
        Properties properties = new Properties();
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            systemConfigFileHelper.setFile(filePath);
            BrokerPathConfigHelper.setBrokerConfigPath(filePath);
            properties = systemConfigFileHelper.loadConfig();
        }
        if (properties != null) {
            BrokerStartup.properties2SystemEnv(properties);
            MixAll.properties2Object((Properties)properties, (Object)brokerConfig);
            MixAll.properties2Object((Properties)properties, (Object)nettyServerConfig);
            MixAll.properties2Object((Properties)properties, (Object)nettyClientConfig);
            MixAll.properties2Object((Properties)properties, (Object)messageStoreConfig);
            MixAll.properties2Object((Properties)properties, (Object)authConfig);
        }
        return new ConfigContext.Builder().configFilePath(filePath).properties(properties).brokerConfig(brokerConfig).messageStoreConfig(messageStoreConfig).nettyServerConfig(nettyServerConfig).nettyClientConfig(nettyClientConfig).authConfig(authConfig).build();
    }

    public static BrokerController buildBrokerController(ConfigContext configContext) {
        String namesrvAddr;
        System.setProperty("rocketmq.remoting.version", Integer.toString(MQVersion.CURRENT_VERSION));
        BrokerConfig brokerConfig = configContext.getBrokerConfig();
        MessageStoreConfig messageStoreConfig = configContext.getMessageStoreConfig();
        NettyClientConfig nettyClientConfig = configContext.getNettyClientConfig();
        NettyServerConfig nettyServerConfig = configContext.getNettyServerConfig();
        AuthConfig authConfig = configContext.getAuthConfig();
        Properties properties = configContext.getProperties();
        if (null == brokerConfig.getRocketmqHome()) {
            System.out.printf("Please set the %s variable in your environment to match the location of the RocketMQ installation", "ROCKETMQ_HOME");
            System.exit(-2);
        }
        if (StringUtils.isNotBlank((CharSequence)(namesrvAddr = brokerConfig.getNamesrvAddr()))) {
            try {
                String[] addrArray;
                for (String addr : addrArray = namesrvAddr.split(";")) {
                    NetworkUtil.string2SocketAddress((String)addr);
                }
            }
            catch (Exception e) {
                System.out.printf("The Name Server Address[%s] illegal, please set it as follows, \"127.0.0.1:9876;192.168.0.1:9876\"%n", namesrvAddr);
                System.exit(-3);
            }
        }
        if (!brokerConfig.isEnableControllerMode()) {
            switch (messageStoreConfig.getBrokerRole()) {
                case ASYNC_MASTER: 
                case SYNC_MASTER: {
                    brokerConfig.setBrokerId(0L);
                    break;
                }
                case SLAVE: {
                    if (brokerConfig.getBrokerId() > 0L) break;
                    System.out.printf("Slave's brokerId must be > 0%n", new Object[0]);
                    System.exit(-3);
                    break;
                }
            }
        }
        if (messageStoreConfig.isEnableDLegerCommitLog()) {
            brokerConfig.setBrokerId(-1L);
        }
        if (brokerConfig.isEnableControllerMode() && messageStoreConfig.isEnableDLegerCommitLog()) {
            System.out.printf("The config enableControllerMode and enableDLegerCommitLog cannot both be true.%n", new Object[0]);
            System.exit(-4);
        }
        if (messageStoreConfig.getHaListenPort() <= 0) {
            messageStoreConfig.setHaListenPort(nettyServerConfig.getListenPort() + 1);
        }
        brokerConfig.setInBrokerContainer(false);
        System.setProperty("brokerLogDir", "");
        if (brokerConfig.isIsolateLogEnable()) {
            System.setProperty("brokerLogDir", brokerConfig.getBrokerName() + "_" + brokerConfig.getBrokerId());
        }
        if (brokerConfig.isIsolateLogEnable() && messageStoreConfig.isEnableDLegerCommitLog()) {
            System.setProperty("brokerLogDir", brokerConfig.getBrokerName() + "_" + messageStoreConfig.getdLegerSelfId());
        }
        log = LoggerFactory.getLogger((String)"RocketmqBroker");
        MixAll.printObjectProperties((Logger)log, (Object)brokerConfig);
        MixAll.printObjectProperties((Logger)log, (Object)nettyServerConfig);
        MixAll.printObjectProperties((Logger)log, (Object)nettyClientConfig);
        MixAll.printObjectProperties((Logger)log, (Object)messageStoreConfig);
        authConfig.setConfigName(brokerConfig.getBrokerName());
        authConfig.setClusterName(brokerConfig.getBrokerClusterName());
        authConfig.setAuthConfigPath(messageStoreConfig.getStorePathRootDir() + File.separator + "config");
        BrokerController controller = new BrokerController(brokerConfig, nettyServerConfig, nettyClientConfig, messageStoreConfig, authConfig);
        controller.getConfiguration().registerConfig(properties);
        controller.setConfigContext(configContext);
        return controller;
    }

    public static Runnable buildShutdownHook(final BrokerController brokerController) {
        return new Runnable(){
            private volatile boolean hasShutdown = false;
            private final AtomicInteger shutdownTimes = new AtomicInteger(0);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    log.info("Shutdown hook was invoked, {}", (Object)this.shutdownTimes.incrementAndGet());
                    if (!this.hasShutdown) {
                        this.hasShutdown = true;
                        long beginTime = System.currentTimeMillis();
                        brokerController.shutdown();
                        long consumingTimeTotal = System.currentTimeMillis() - beginTime;
                        log.info("Shutdown hook over, consuming total time(ms): {}", (Object)consumingTimeTotal);
                    }
                }
            }
        };
    }

    public static BrokerController createBrokerController(String[] args) {
        try {
            ConfigContext configContext = BrokerStartup.parseCmdLine(args);
            BrokerController controller = BrokerStartup.buildBrokerController(configContext);
            boolean initResult = controller.initialize();
            if (!initResult) {
                controller.shutdown();
                System.exit(-3);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(BrokerStartup.buildShutdownHook(controller)));
            return controller;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    private static void properties2SystemEnv(Properties properties) {
        if (properties == null) {
            return;
        }
        String rmqAddressServerDomain = properties.getProperty("rmqAddressServerDomain", MixAll.WS_DOMAIN_NAME);
        String rmqAddressServerSubGroup = properties.getProperty("rmqAddressServerSubGroup", MixAll.WS_DOMAIN_SUBGROUP);
        System.setProperty("rocketmq.namesrv.domain", rmqAddressServerDomain);
        System.setProperty("rocketmq.namesrv.domain.subgroup", rmqAddressServerSubGroup);
    }

    private static Options buildCommandlineOptions(Options options) {
        Option opt = new Option("c", "configFile", true, "Broker config properties file");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("p", "printConfigItem", false, "Print all config item");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("m", "printImportantConfig", false, "Print important config item");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    public static class SystemConfigFileHelper {
        private static final Logger LOGGER = LoggerFactory.getLogger(SystemConfigFileHelper.class);
        private String file;

        public Properties loadConfig() throws Exception {
            Properties properties = new Properties();
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(Paths.get(this.file, new String[0]), new OpenOption[0]));){
                properties.load(in);
            }
            return properties;
        }

        public void update(Properties properties) throws Exception {
            LOGGER.error("[SystemConfigFileHelper] update no thing.");
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }
    }
}

