/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.pop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class PopConsumerRecord {
    @JSONField
    private long popTime;
    @JSONField(ordinal=1)
    private String groupId;
    @JSONField(ordinal=2)
    private String topicId;
    @JSONField(ordinal=3)
    private int queueId;
    @JSONField(ordinal=4)
    private int retryFlag;
    @JSONField(ordinal=5)
    private long invisibleTime;
    @JSONField(ordinal=6)
    private long offset;
    @JSONField(ordinal=7)
    private int attemptTimes;
    @JSONField(ordinal=8)
    private String attemptId;

    public PopConsumerRecord() {
    }

    public PopConsumerRecord(long popTime, String groupId, String topicId, int queueId, int retryFlag, long invisibleTime, long offset, String attemptId) {
        this.popTime = popTime;
        this.groupId = groupId;
        this.topicId = topicId;
        this.queueId = queueId;
        this.retryFlag = retryFlag;
        this.invisibleTime = invisibleTime;
        this.offset = offset;
        this.attemptId = attemptId;
    }

    @JSONField(serialize=false)
    public long getVisibilityTimeout() {
        return this.popTime + this.invisibleTime;
    }

    @JSONField(serialize=false)
    public byte[] getKeyBytes() {
        int length = 8 + this.groupId.length() + 1 + this.topicId.length() + 1 + 4 + 1 + 8;
        byte[] bytes = new byte[length];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.putLong(this.getVisibilityTimeout());
        buffer.put(this.groupId.getBytes(StandardCharsets.UTF_8)).put((byte)64);
        buffer.put(this.topicId.getBytes(StandardCharsets.UTF_8)).put((byte)64);
        buffer.putInt(this.queueId).put((byte)64);
        buffer.putLong(this.offset);
        return bytes;
    }

    @JSONField(serialize=false)
    public boolean isRetry() {
        return this.retryFlag != 0;
    }

    @JSONField(serialize=false)
    public byte[] getValueBytes() {
        return JSON.toJSONBytes((Object)this, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static PopConsumerRecord decode(byte[] body) {
        return (PopConsumerRecord)JSONObject.parseObject((byte[])body, PopConsumerRecord.class, (Feature[])new Feature[0]);
    }

    public long getPopTime() {
        return this.popTime;
    }

    public void setPopTime(long popTime) {
        this.popTime = popTime;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public void setQueueId(int queueId) {
        this.queueId = queueId;
    }

    public int getRetryFlag() {
        return this.retryFlag;
    }

    public void setRetryFlag(int retryFlag) {
        this.retryFlag = retryFlag;
    }

    public long getInvisibleTime() {
        return this.invisibleTime;
    }

    public void setInvisibleTime(long invisibleTime) {
        this.invisibleTime = invisibleTime;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public int getAttemptTimes() {
        return this.attemptTimes;
    }

    public void setAttemptTimes(int attemptTimes) {
        this.attemptTimes = attemptTimes;
    }

    public String getAttemptId() {
        return this.attemptId;
    }

    public void setAttemptId(String attemptId) {
        this.attemptId = attemptId;
    }

    public String toString() {
        return "PopDeliveryRecord{popTime=" + this.popTime + ", groupId='" + this.groupId + '\'' + ", topicId='" + this.topicId + '\'' + ", queueId=" + this.queueId + ", retryFlag=" + this.retryFlag + ", invisibleTime=" + this.invisibleTime + ", offset=" + this.offset + ", attemptTimes=" + this.attemptTimes + ", attemptId='" + this.attemptId + '\'' + '}';
    }

    public static enum RetryType {
        NORMAL_TOPIC(0),
        RETRY_TOPIC_V1(1),
        RETRY_TOPIC_V2(2);

        private final int code;

        private RetryType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

